/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.network.ExtendedGhastInteractionPayload;
import dev.nweaver.happyghastmod.network.GhastPlatformStatePayload;
import dev.nweaver.happyghastmod.network.GhastRotationSyncPayload;
import dev.nweaver.happyghastmod.network.GhastSpeedSyncPayload;
import dev.nweaver.happyghastmod.network.GhastVerticalMovementPayload;
import dev.nweaver.happyghastmod.network.OpenGhastInventoryPayload;
import dev.nweaver.happyghastmod.network.OpenHarnessCreatorPayload;
import dev.nweaver.happyghastmod.network.RegisterCustomHarnessPayload;
import dev.nweaver.happyghastmod.network.SyncCustomHarnessPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        LOGGER.info("Registering network payload handlers for {}", (Object)"happyghastmod");
        PayloadRegistrar registrar = event.registrar("happyghastmod").versioned(PROTOCOL_VERSION);
        registrar.playToServer(OpenGhastInventoryPayload.TYPE, OpenGhastInventoryPayload.STREAM_CODEC, OpenGhastInventoryPayload::handle);
        registrar.playToServer(RegisterCustomHarnessPayload.TYPE, RegisterCustomHarnessPayload.STREAM_CODEC, RegisterCustomHarnessPayload::handle);
        registrar.playToServer(ExtendedGhastInteractionPayload.TYPE, ExtendedGhastInteractionPayload.STREAM_CODEC, ExtendedGhastInteractionPayload::handle);
        registrar.playToServer(GhastPlatformStatePayload.TYPE, GhastPlatformStatePayload.STREAM_CODEC, GhastPlatformStatePayload::handle);
        registrar.playToClient(SyncCustomHarnessPayload.TYPE, SyncCustomHarnessPayload.STREAM_CODEC, SyncCustomHarnessPayload::handle);
        registrar.playToClient(OpenHarnessCreatorPayload.TYPE, OpenHarnessCreatorPayload.STREAM_CODEC, OpenHarnessCreatorPayload::handle);
        registrar.playToClient(GhastRotationSyncPayload.TYPE, GhastRotationSyncPayload.STREAM_CODEC, GhastRotationSyncPayload::handle);
        registrar.playToServer(GhastVerticalMovementPayload.TYPE, GhastVerticalMovementPayload.STREAM_CODEC, GhastVerticalMovementPayload::handle);
        registrar.playToClient(GhastSpeedSyncPayload.TYPE, GhastSpeedSyncPayload.STREAM_CODEC, GhastSpeedSyncPayload::handle);
        LOGGER.info("Finished registering network payload handlers.");
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(CustomPacketPayload payload, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(CustomPacketPayload payload) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

