/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GhastVerticalMovementPayload(boolean isAscending, boolean isDescending) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GhastVerticalMovementPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"ghast_vertical_movement"));
    public static final StreamCodec<ByteBuf, GhastVerticalMovementPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, GhastVerticalMovementPayload::isAscending, (StreamCodec)ByteBufCodecs.BOOL, GhastVerticalMovementPayload::isDescending, GhastVerticalMovementPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GhastVerticalMovementPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            Entity vehicle;
            if (context.flow() == PacketFlow.SERVERBOUND && (vehicle = (player = context.player()).getVehicle()) instanceof HappyGhast) {
                HappyGhast happyGhast = (HappyGhast)vehicle;
                happyGhast.setAscending(payload.isAscending());
                happyGhast.setDescending(payload.isDescending());
            }
        });
    }
}

