/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastMovementComponent;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record GhastSpeedSyncPayload(float speedMultiplier) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<GhastSpeedSyncPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"ghast_speed_sync"));
    public static final StreamCodec<ByteBuf, GhastSpeedSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, GhastSpeedSyncPayload::speedMultiplier, GhastSpeedSyncPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GhastSpeedSyncPayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                LOGGER.debug("Received speed multiplier: {}", (Object)Float.valueOf(payload.speedMultiplier()));
                try {
                    GhastMovementComponent.SPEED_MULTIPLIER = payload.speedMultiplier();
                }
                catch (Exception e) {
                    LOGGER.debug("Could not set static speed multiplier: {}", (Object)e.getMessage());
                }
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.level != null) {
                    minecraft.level.entitiesForRendering().forEach(entity -> {
                        if (entity instanceof HappyGhast) {
                            HappyGhast happyGhast = (HappyGhast)((Object)((Object)entity));
                            happyGhast.setSpeedMultiplier(payload.speedMultiplier());
                        }
                    });
                    LOGGER.debug("Updated speed multiplier to: {}", (Object)Float.valueOf(payload.speedMultiplier()));
                }
            });
        }
    }
}

