/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GhastRotationSyncPayload(int entityId, float yRot, float xRot, float yBodyRot, float yHeadRot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GhastRotationSyncPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"ghast_rotation_sync"));
    public static final StreamCodec<ByteBuf, GhastRotationSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, GhastRotationSyncPayload::entityId, (StreamCodec)ByteBufCodecs.FLOAT, GhastRotationSyncPayload::yRot, (StreamCodec)ByteBufCodecs.FLOAT, GhastRotationSyncPayload::xRot, (StreamCodec)ByteBufCodecs.FLOAT, GhastRotationSyncPayload::yBodyRot, (StreamCodec)ByteBufCodecs.FLOAT, GhastRotationSyncPayload::yHeadRot, GhastRotationSyncPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GhastRotationSyncPayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.level == null) {
                    return;
                }
                Entity entity = minecraft.level.getEntity(payload.entityId());
                if (entity instanceof HappyGhast) {
                    boolean isDriver;
                    HappyGhast happyGhast = (HappyGhast)entity;
                    boolean bl = isDriver = !happyGhast.getPassengers().isEmpty() && happyGhast.getPassengers().get(0) == minecraft.player;
                    if (!isDriver) {
                        happyGhast.setTargetServerRotation(payload.yRot(), payload.xRot(), payload.yBodyRot(), payload.yHeadRot());
                    }
                }
            });
        }
    }
}

