/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record GhastPlatformStatePayload(int entityId, boolean isStationaryPlatform) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<GhastPlatformStatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"ghast_platform_state"));
    public static final StreamCodec<ByteBuf, GhastPlatformStatePayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, GhastPlatformStatePayload::entityId, (StreamCodec)ByteBufCodecs.BOOL, GhastPlatformStatePayload::isStationaryPlatform, GhastPlatformStatePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GhastPlatformStatePayload payload, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                block9: {
                    LOGGER.debug("Received platform state update for entity {}: isStationary={}", (Object)payload.entityId(), (Object)payload.isStationaryPlatform());
                    Minecraft minecraft = Minecraft.getInstance();
                    if (minecraft.level == null) {
                        LOGGER.debug("Client level is null, cannot update entity");
                        return;
                    }
                    Entity entity = minecraft.level.getEntity(payload.entityId());
                    if (entity == null) {
                        LOGGER.debug("Could not find entity with ID {}", (Object)payload.entityId());
                        return;
                    }
                    if (entity instanceof HappyGhast) {
                        HappyGhast happyGhast = (HappyGhast)entity;
                        if (payload.isStationaryPlatform()) {
                            happyGhast.setDeltaMovement(0.0, 0.0, 0.0);
                            if (happyGhast.getPlatformComponent() != null) {
                                try {
                                    if (payload.isStationaryPlatform()) {
                                        happyGhast.getPlatformComponent().activate();
                                        break block9;
                                    }
                                    happyGhast.getPlatformComponent().deactivate();
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error updating platform state: {}", (Object)e.getMessage());
                                }
                            }
                        }
                    } else {
                        LOGGER.debug("Entity with ID {} is not a HappyGhast", (Object)payload.entityId());
                    }
                }
            });
        }
    }
}

