/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.events.ExtendedGhastInteractionHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ExtendedGhastInteractionPayload(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ExtendedGhastInteractionPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"extended_ghast_interaction"));
    public static final StreamCodec<ByteBuf, ExtendedGhastInteractionPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ExtendedGhastInteractionPayload::entityId, ExtendedGhastInteractionPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ExtendedGhastInteractionPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            Player player = context.player();
            if (player != null && player.level() != null && (entity = player.level().getEntity(payload.entityId())) instanceof HappyGhast) {
                HappyGhast ghast = (HappyGhast)entity;
                ExtendedGhastInteractionHandler.handleExtendedInteraction(player, (Entity)ghast);
            }
        });
    }
}

