/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.item;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class EntitySpawnItem
extends Item {
    private final Supplier<EntityType<?>> entityTypeSupplier;

    public EntitySpawnItem(Supplier<EntityType<?>> entityTypeSupplier, Item.Properties properties) {
        super(properties);
        this.entityTypeSupplier = entityTypeSupplier;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        Player player = context.getPlayer();
        BlockPos spawnPos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        EntityType<?> entitytype = this.entityTypeSupplier.get();
        if (entitytype.spawn(serverLevel, itemstack, player, spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, spawnPos) && direction == Direction.UP) != null) {
            itemstack.shrink(1);
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            level.playSound(null, spawnPos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, spawnPos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }
}

