/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.item;

import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.item.HarnessItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomHarnessItem
extends HarnessItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public CustomHarnessItem(Item.Properties properties, String color) {
        super(properties, color);
    }

    @Override
    public Component getName(ItemStack stack) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains("CustomHarnessId", 8) && tag.contains("CustomHarnessName", 8)) {
            String customName = tag.getString("CustomHarnessName");
            return Component.literal((String)customName);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = customData.copyTag();
        if (tag.contains("CustomHarnessId", 8)) {
            ClientCustomHarnessManager.HarnessInfo info;
            String harnessId = tag.getString("CustomHarnessId");
            Level level = context.level();
            if (level != null && level.isClientSide && (info = ClientCustomHarnessManager.getCustomHarnessInfo(harnessId)) != null) {
                tooltip.add((Component)Component.translatable((String)"tooltip.happyghastmod.custom_harness_creator", (Object[])new Object[]{info.getCreatorName()}));
            }
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.happyghastmod.harness"));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Nullable
    public static String getCustomHarnessId(ItemStack stack) {
        CompoundTag tag;
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && (tag = customData.copyTag()).contains("CustomHarnessId", 8)) {
            return tag.getString("CustomHarnessId");
        }
        return null;
    }

    public static boolean isCustomHarness(ItemStack stack) {
        return CustomHarnessItem.getCustomHarnessId(stack) != null;
    }

    @Override
    public String getColor() {
        return super.getColor();
    }

    public static String getStackColor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof HarnessItem) {
            HarnessItem harnessItem = (HarnessItem)item;
            if (CustomHarnessItem.isCustomHarness(stack)) {
                return "custom";
            }
            return harnessItem.getColor();
        }
        return "blue";
    }
}

