/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.events;

import com.mojang.blaze3d.platform.InputConstants;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.network.GhastVerticalMovementPayload;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="happyghastmod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NewKeyHandler {
    public static final KeyMapping GHAST_ASCEND = new KeyMapping("key.happyghastmod.ascend", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(32), "key.categories.happyghastmod");
    public static final KeyMapping GHAST_DESCEND = new KeyMapping("key.happyghastmod.descend", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(67), "key.categories.happyghastmod");
    private static boolean wasAscending = false;
    private static boolean wasDescending = false;
    private static boolean wasRidingGhast = false;

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(GHAST_ASCEND);
        event.register(GHAST_DESCEND);
        HappyGhastMod.LOGGER.info("Registered Happy Ghast key bindings");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        NeoForge.EVENT_BUS.addListener(NewKeyHandler::onKeyInput);
        Thread ridingCheckThread = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(500L);
                    Minecraft minecraft = Minecraft.getInstance();
                    if (minecraft == null || minecraft.level == null) continue;
                    minecraft.execute(NewKeyHandler::checkRidingStatus);
                }
            }
            catch (InterruptedException e) {
                HappyGhastMod.LOGGER.error("Happy Ghast riding check thread interrupted", (Throwable)e);
                return;
            }
        }, "HappyGhast-RidingCheck");
        ridingCheckThread.setDaemon(true);
        ridingCheckThread.start();
        HappyGhastMod.LOGGER.info("Happy Ghast key handler initialized");
    }

    private static void checkRidingStatus() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        Entity vehicle = player.getVehicle();
        boolean isRidingGhast = vehicle instanceof HappyGhast;
        if (isRidingGhast != wasRidingGhast) {
            wasRidingGhast = isRidingGhast;
            if (!isRidingGhast) {
                wasAscending = false;
                wasDescending = false;
                return;
            }
            NewKeyHandler.sendMovementPacket(false, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof HappyGhast) {
            boolean isAscending = GHAST_ASCEND.isDown();
            boolean isDescending = GHAST_DESCEND.isDown();
            if (isAscending != wasAscending || isDescending != wasDescending) {
                NewKeyHandler.sendMovementPacket(isAscending, isDescending);
            }
        }
    }

    private static void sendMovementPacket(boolean isAscending, boolean isDescending) {
        GhastVerticalMovementPayload payload = new GhastVerticalMovementPayload(isAscending, isDescending);
        NetworkHandler.sendToServer(payload);
        HappyGhastMod.LOGGER.debug("Sending vertical movement packet: ascending={}, descending={}", (Object)isAscending, (Object)isDescending);
        wasAscending = isAscending;
        wasDescending = isDescending;
    }
}

