/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.events;

import dev.nweaver.happyghastmod.entity.Ghastling;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="happyghastmod")
public class IronGolemTargetingHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"happyghastmod");

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getNewAboutToBeSetTarget();
        if (target instanceof HappyGhast || target instanceof Ghastling) {
            boolean shouldCancel = false;
            if (attacker instanceof IronGolem) {
                shouldCancel = true;
            } else if (attacker instanceof SnowGolem) {
                shouldCancel = true;
            } else if (attacker instanceof Mob && attacker.getType().getDescriptionId().contains("guardvillagers")) {
                shouldCancel = true;
            }
            if (shouldCancel) {
                event.setCanceled(true);
                if (attacker instanceof Mob) {
                    Mob mobAttacker = (Mob)attacker;
                    mobAttacker.setTarget(null);
                }
                LOGGER.debug("Prevented attack on Happy Ghast by: " + attacker.getType().getDescriptionId());
            }
        }
    }
}

