/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.events;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.network.ExtendedGhastInteractionPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="happyghastmod")
public class ExtendedGhastInteractionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double EXTENDED_INTERACTION_DISTANCE = 10.0;

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            Vec3 eyePosition = player.getEyePosition();
            Vec3 lookVector = player.getViewVector(1.0f);
            Vec3 reachVector = eyePosition.add(lookVector.x * 10.0, lookVector.y * 10.0, lookVector.z * 10.0);
            AABB searchBox = new AABB(Math.min(eyePosition.x, reachVector.x) - 1.0, Math.min(eyePosition.y, reachVector.y) - 1.0, Math.min(eyePosition.z, reachVector.z) - 1.0, Math.max(eyePosition.x, reachVector.x) + 1.0, Math.max(eyePosition.y, reachVector.y) + 1.0, Math.max(eyePosition.z, reachVector.z) + 1.0);
            player.level().getEntitiesOfClass(HappyGhast.class, searchBox, entity -> {
                double distSq = entity.distanceToSqr(eyePosition);
                if (distSq > 100.0) {
                    return false;
                }
                AABB entityBox = entity.getBoundingBox().inflate(0.5);
                Vec3 entityCenter = entityBox.getCenter();
                Vec3 toEntity = entityCenter.subtract(eyePosition);
                double length = toEntity.length();
                double dot = (toEntity = toEntity.normalize()).dot(lookVector);
                return dot > 0.95;
            }).stream().min((e1, e2) -> Double.compare(e1.distanceToSqr(eyePosition), e2.distanceToSqr(eyePosition))).ifPresent(ghast -> PacketDistributor.sendToServer((CustomPacketPayload)new ExtendedGhastInteractionPayload(ghast.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public static void handleExtendedInteraction(Player player, Entity entity) {
        if (entity instanceof HappyGhast) {
            InteractionResult result;
            HappyGhast ghast = (HappyGhast)entity;
            double distanceSq = player.distanceToSqr(entity);
            if (distanceSq <= 100.0 && (result = ghast.mobInteract(player, InteractionHand.MAIN_HAND)) == InteractionResult.SUCCESS) {
                LOGGER.debug("Extended interaction successful with ghast {} at distance {}", (Object)ghast.getId(), (Object)Math.sqrt(distanceSq));
            }
        }
    }
}

