/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastRandomFloatGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghast ghast;

    public HappyGhastRandomFloatGoal(Ghast ghast) {
        this.ghast = ghast;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double d2;
        double d1;
        if (AnchorManager.isFollowing((Entity)this.ghast)) {
            return false;
        }
        MoveControl movecontrol = this.ghast.getMoveControl();
        if (!movecontrol.hasWanted()) {
            return true;
        }
        double d0 = movecontrol.getWantedX() - this.ghast.getX();
        double d3 = d0 * d0 + (d1 = movecontrol.getWantedY() - this.ghast.getY()) * d1 + (d2 = movecontrol.getWantedZ() - this.ghast.getZ()) * d2;
        return d3 < 1.0 || d3 > 3600.0;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        RandomSource randomsource = this.ghast.getRandom();
        if (this.ghast.isLeashed()) {
            double d0 = this.ghast.getX() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghast.getY() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 8.0f);
            double d2 = this.ghast.getZ() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (d1 < (double)(this.ghast.level().getSeaLevel() + 5)) {
                d1 = this.ghast.level().getSeaLevel() + 5 + randomsource.nextInt(10);
            }
            this.ghast.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
            return;
        }
        if (AnchorManager.hasAnchor((Entity)this.ghast)) {
            Vec3 anchor = AnchorManager.getAnchor((Entity)this.ghast);
            double maxRadius = AnchorManager.getMaxRadius((Entity)this.ghast);
            double angle = (double)(randomsource.nextFloat() * 2.0f) * Math.PI;
            double horizontalDist = (double)randomsource.nextFloat() * maxRadius;
            double offsetX = horizontalDist * Math.cos(angle);
            double offsetZ = horizontalDist * Math.sin(angle);
            double minOffset = AnchorManager.getMinHeightOffset();
            double maxOffset = AnchorManager.getMaxHeightOffset();
            double offsetY = this.ghast.getY() > anchor.y + 10.0 ? minOffset * 0.8 + (double)randomsource.nextFloat() * (maxOffset * 0.4) : minOffset + (double)randomsource.nextFloat() * (maxOffset - minOffset);
            double d0 = anchor.x + offsetX;
            double d1 = anchor.y + offsetY;
            double d2 = anchor.z + offsetZ;
            if (d1 < (double)(this.ghast.level().getSeaLevel() + 5)) {
                d1 = this.ghast.level().getSeaLevel() + 5 + randomsource.nextInt(10);
            }
            this.ghast.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
        } else {
            double d0 = this.ghast.getX() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double verticalOffset = this.ghast.getY() > 100.0 ? (double)((randomsource.nextFloat() * 0.8f - 0.6f) * 8.0f) : (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 4.0f);
            double d1 = this.ghast.getY() + verticalOffset;
            double d2 = this.ghast.getZ() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 16.0f);
            if (d1 < (double)(this.ghast.level().getSeaLevel() + 5)) {
                d1 = this.ghast.level().getSeaLevel() + 5 + randomsource.nextInt(10);
            }
            this.ghast.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
        }
    }
}

