/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.phys.Vec3;

public class HappyGhastLookGoal
extends Goal {
    private final Ghast ghast;
    private float lastYRot = 0.0f;
    private float targetYRot = 0.0f;
    private Vec3 smoothedDirection = null;
    private static final double DIR_SMOOTHING_LEASHED = 0.05;
    private int rotationHoldTimer = 0;
    private static final int MIN_ROTATION_HOLD_TICKS = 10;
    private static final double MIN_VELOCITY_FOR_ROTATION = 0.02;
    private static final float MAX_ROTATION_SPEED_LEASHED = 1.5f;

    public HappyGhastLookGoal(Ghast ghast) {
        this.ghast = ghast;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        this.lastYRot = ghast.getYRot();
        this.targetYRot = ghast.getYRot();
    }

    public boolean canUse() {
        return true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        HappyGhast happyGhast;
        boolean isLeashed = false;
        Entity leashHolder = null;
        Ghast ghast = this.ghast;
        if (ghast instanceof HappyGhast && (isLeashed = (happyGhast = (HappyGhast)ghast).isLeashed())) {
            leashHolder = happyGhast.getLeashHolder();
        }
        if (isLeashed && leashHolder != null) {
            this.tickLeashed(leashHolder);
        } else {
            this.tickNormal();
            this.smoothedDirection = null;
            this.rotationHoldTimer = 0;
        }
    }

    private void tickNormal() {
        Vec3 vec3 = this.ghast.getDeltaMovement();
        if (vec3.horizontalDistanceSqr() > 1.0E-4) {
            float newYRot = -((float)Mth.atan2((double)vec3.x, (double)vec3.z)) * 57.295776f;
            this.ghast.setYRot(newYRot);
            this.ghast.yBodyRot = this.ghast.getYRot();
            this.lastYRot = newYRot;
            this.targetYRot = newYRot;
        }
    }

    private void tickLeashed(Entity leashHolder) {
        boolean shouldUpdateDirection;
        Vec3 motionVector = this.ghast.getDeltaMovement();
        double horizontalSpeed = motionVector.horizontalDistance();
        boolean bl = shouldUpdateDirection = horizontalSpeed > 0.02 || this.rotationHoldTimer <= 0;
        if (shouldUpdateDirection) {
            float newTargetYRot;
            float rotDiff;
            this.rotationHoldTimer = 10;
            Vec3 directionVector = motionVector;
            if (horizontalSpeed > 0.01) {
                Vec3 toLeashHolder = leashHolder.position().subtract(this.ghast.position()).normalize();
                directionVector = motionVector.normalize().scale(0.7).add(toLeashHolder.scale(0.3));
            }
            if (this.smoothedDirection == null) {
                this.smoothedDirection = directionVector;
            } else if (directionVector.horizontalDistanceSqr() > 1.0E-4) {
                this.smoothedDirection = this.smoothedDirection.scale(0.95).add(directionVector.scale(0.05));
            }
            if (this.smoothedDirection.horizontalDistanceSqr() > 1.0E-4 && Math.abs(rotDiff = Mth.wrapDegrees((float)((newTargetYRot = -((float)Mth.atan2((double)this.smoothedDirection.x, (double)this.smoothedDirection.z)) * 57.295776f) - this.targetYRot))) > 5.0f) {
                this.targetYRot = newTargetYRot;
            }
        } else {
            --this.rotationHoldTimer;
        }
        float rotationDiff = Mth.wrapDegrees((float)(this.targetYRot - this.lastYRot));
        float rotationStep = Mth.clamp((float)rotationDiff, (float)-1.5f, (float)1.5f);
        this.lastYRot = Mth.wrapDegrees((float)(this.lastYRot + rotationStep));
        this.ghast.setYRot(this.lastYRot);
        this.ghast.yBodyRot = this.ghast.getYRot();
    }
}

