/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import java.util.EnumSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhastFollowPlayerWithItemGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghast ghast;
    private Player player;
    private final double speedModifier;
    private final float startDistance;
    private double smoothedTargetY = Double.NaN;
    private static final double VERTICAL_SMOOTHING = 0.08;
    private int verticalPositionMode = 0;
    private int positionChangeTimer = 0;
    private static final int POSITION_CHANGE_INTERVAL = 200;
    private static final float MIN_VERTICAL_OFFSET = 3.0f;
    private static final float[] VERTICAL_OFFSETS = new float[]{5.0f, 0.0f, -8.0f};
    private boolean forcePositionChange = true;
    private boolean wasHoldingItem = false;

    public HappyGhastFollowPlayerWithItemGoal(Ghast ghast, double speedModifier, float startDistance) {
        this.ghast = ghast;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        boolean shouldFollow;
        this.player = this.ghast.level().getNearestPlayer((Entity)this.ghast, (double)(this.startDistance * 3.0f));
        if (this.player == null) {
            if (this.wasHoldingItem) {
                this.wasHoldingItem = false;
                AnchorManager.stopFollowing((Entity)this.ghast);
            }
            return false;
        }
        boolean holdingFollowItem = this.isHoldingFollowItem(this.player);
        if (holdingFollowItem && !this.wasHoldingItem) {
            AnchorManager.markAsFollowing((Entity)this.ghast);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.getX(), this.player.getY(), this.player.getZ());
        } else if (!holdingFollowItem && this.wasHoldingItem) {
            AnchorManager.stopFollowing((Entity)this.ghast);
        }
        this.wasHoldingItem = holdingFollowItem;
        boolean bl = shouldFollow = holdingFollowItem && this.ghast.distanceToSqr((Entity)this.player) > 16.0;
        if (holdingFollowItem && !shouldFollow && AnchorManager.hasAnchor((Entity)this.ghast)) {
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.getX(), this.player.getY(), this.player.getZ());
            double distanceSq = this.ghast.distanceToSqr((Entity)this.player);
            if (distanceSq > 256.0 && AnchorManager.canUpdateAnchor((Entity)this.ghast)) {
                AnchorManager.createTemporaryAnchor((Entity)this.ghast, this.player.getX(), this.player.getY(), this.player.getZ());
            }
        }
        return shouldFollow;
    }

    public boolean canContinueToUse() {
        return this.isHoldingFollowItem(this.player) && this.ghast.distanceToSqr((Entity)this.player) > 16.0 && this.player.isAlive();
    }

    public void stop() {
        this.player = null;
        if (this.wasHoldingItem) {
            this.wasHoldingItem = false;
            AnchorManager.stopFollowing((Entity)this.ghast);
        }
        this.smoothedTargetY = Double.NaN;
    }

    private boolean isHoldingFollowItem(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        return this.isSnowballOrHarness(mainHand) || this.isSnowballOrHarness(offHand);
    }

    private boolean isSnowballOrHarness(ItemStack stack) {
        if (stack.is(Items.SNOWBALL)) {
            return true;
        }
        String itemId = stack.getItem().toString().toLowerCase();
        boolean isHarness = itemId.contains("harness");
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            isHarness = isHarness || ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().contains("HarnessColor");
        }
        return isHarness;
    }

    private boolean isPlayerShowingFollowItem(Player player) {
        return this.isHoldingFollowItem(player);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean currentlyHoldingItem = this.isHoldingFollowItem(this.player);
        if (!currentlyHoldingItem && this.wasHoldingItem) {
            this.wasHoldingItem = false;
            AnchorManager.stopFollowing((Entity)this.ghast);
            return;
        }
        this.wasHoldingItem = currentlyHoldingItem;
        if (currentlyHoldingItem) {
            AnchorManager.markAsFollowing((Entity)this.ghast);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghast, this.player.getX(), this.player.getY(), this.player.getZ());
        }
        double dx = this.player.getX() - this.ghast.getX();
        double dz = this.player.getZ() - this.ghast.getZ();
        this.ghast.setYRot(-((float)Mth.atan2((double)dx, (double)dz)) * 57.295776f);
        this.ghast.yBodyRot = this.ghast.getYRot();
        if (this.ghast.getY() > this.player.getY() + 15.0) {
            this.verticalPositionMode = 2;
            this.positionChangeTimer = 0;
            this.forcePositionChange = false;
            this.smoothedTargetY = Double.NaN;
        } else {
            ++this.positionChangeTimer;
            if (this.positionChangeTimer >= 200 || this.forcePositionChange) {
                int newMode;
                while ((newMode = this.ghast.getRandom().nextInt(3)) == this.verticalPositionMode && !this.forcePositionChange) {
                }
                this.verticalPositionMode = newMode;
                this.positionChangeTimer = 0;
                this.forcePositionChange = false;
                String[] positionNames = new String[]{"\u0421\u0412\u0415\u0420\u0425\u0423", "\u041d\u0410 \u0423\u0420\u041e\u0412\u041d\u0415", "\u0421\u041d\u0418\u0417\u0423"};
                LOGGER.debug("Ghast position changed to: {}", (Object)positionNames[this.verticalPositionMode]);
                this.smoothedTargetY = Double.NaN;
            }
        }
        double targetY = this.player.getY() + (double)VERTICAL_OFFSETS[this.verticalPositionMode];
        double minHeight = this.ghast.level().getSeaLevel() + 4;
        if (targetY < minHeight) {
            targetY = minHeight;
        }
        if (Double.isNaN(this.smoothedTargetY)) {
            this.smoothedTargetY = this.ghast.getY();
        }
        double heightDiff = Math.abs(targetY - this.ghast.getY());
        double verticalSpeed = targetY < this.ghast.getY() && heightDiff > 8.0 ? 0.3 : (heightDiff > 10.0 ? 0.2 : (heightDiff > 5.0 ? 0.1 : 0.05));
        this.smoothedTargetY += (targetY - this.smoothedTargetY) * verticalSpeed;
        double idealHeight = this.smoothedTargetY;
        if (this.ghast.distanceToSqr((Entity)this.player) > 64.0) {
            double offsetX = this.player.getX() + (double)(this.ghast.getRandom().nextFloat() * 8.0f - 4.0f);
            double offsetY = idealHeight;
            double offsetZ = this.player.getZ() + (double)(this.ghast.getRandom().nextFloat() * 8.0f - 4.0f);
            boolean canMove = true;
            if (!currentlyHoldingItem) {
                canMove = AnchorManager.isWithinAllowedRadius((Entity)this.ghast, offsetX, offsetY, offsetZ);
            }
            if (canMove) {
                this.ghast.getMoveControl().setWantedPosition(offsetX, offsetY, offsetZ, this.speedModifier);
            } else if (AnchorManager.hasAnchor((Entity)this.ghast)) {
                Vec3 anchor = AnchorManager.getAnchor((Entity)this.ghast);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this.ghast);
                Vec3 dirToPlayer = new Vec3(this.player.getX() - anchor.x, 0.0, this.player.getZ() - anchor.z).normalize();
                double newX = anchor.x + dirToPlayer.x * maxRadius * 0.8;
                double newZ = anchor.z + dirToPlayer.z * maxRadius * 0.8;
                this.ghast.getMoveControl().setWantedPosition(newX, offsetY, newZ, this.speedModifier);
            }
        } else {
            double dist = Math.sqrt(this.ghast.distanceToSqr((Entity)this.player));
            if (dist < 10.0) {
                Vec3 moveAwayVec = new Vec3(this.ghast.getX() - this.player.getX(), 0.0, this.ghast.getZ() - this.player.getZ()).normalize();
                double newX = this.ghast.getX() + moveAwayVec.x * 2.0;
                double newY = idealHeight;
                double newZ = this.ghast.getZ() + moveAwayVec.z * 2.0;
                boolean canMove = true;
                if (!currentlyHoldingItem) {
                    canMove = AnchorManager.isWithinAllowedRadius((Entity)this.ghast, newX, newY, newZ);
                }
                if (canMove) {
                    this.ghast.getMoveControl().setWantedPosition(newX, newY, newZ, 1.0);
                }
            } else {
                this.ghast.getMoveControl().setWantedPosition(this.ghast.getX(), idealHeight, this.ghast.getZ(), 0.5);
            }
        }
    }
}

