/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.Ghastling;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingRandomFloatGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghastling ghastling;

    public GhastlingRandomFloatGoal(Ghastling ghastling) {
        this.ghastling = ghastling;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double d2;
        double d1;
        if (AnchorManager.isFollowing((Entity)this.ghastling)) {
            return false;
        }
        MoveControl movecontrol = this.ghastling.getMoveControl();
        if (!movecontrol.hasWanted()) {
            return true;
        }
        double d0 = movecontrol.getWantedX() - this.ghastling.getX();
        double d3 = d0 * d0 + (d1 = movecontrol.getWantedY() - this.ghastling.getY()) * d1 + (d2 = movecontrol.getWantedZ() - this.ghastling.getZ()) * d2;
        return d3 < 1.0 || d3 > 3600.0;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        RandomSource randomsource = this.ghastling.getRandom();
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        boolean validPointFound = false;
        for (int attempt = 0; attempt < 5 && !validPointFound; ++attempt) {
            if (this.ghastling.isLeashed()) {
                d0 = this.ghastling.getX() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 6.0f);
                d1 = this.ghastling.getY() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 4.0f);
                d2 = this.ghastling.getZ() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 6.0f);
            } else if (AnchorManager.hasAnchor((Entity)this.ghastling)) {
                Vec3 anchor = AnchorManager.getAnchor((Entity)this.ghastling);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this.ghastling);
                double angle = (double)(randomsource.nextFloat() * 2.0f) * Math.PI;
                double horizontalDist = (double)randomsource.nextFloat() * maxRadius * 0.8;
                d0 = anchor.x + horizontalDist * Math.cos(angle);
                int groundY = this.findGroundHeight(d0, d2 = anchor.z + horizontalDist * Math.sin(angle));
                d1 = groundY != -1 ? (double)((float)(groundY + 1) + randomsource.nextFloat() * 1.0f) : anchor.y + (-2.0 + (double)randomsource.nextFloat() * 4.0);
            } else {
                d0 = this.ghastling.getX() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 8.0f);
                d1 = this.ghastling.getY() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 3.0f);
                d2 = this.ghastling.getZ() + (double)((randomsource.nextFloat() * 2.0f - 1.0f) * 8.0f);
            }
            BlockPos targetPos = new BlockPos(Mth.floor((double)d0), Mth.floor((double)d1), Mth.floor((double)d2));
            FluidState fluidState = this.ghastling.level().getFluidState(targetPos);
            if (!fluidState.isEmpty() && fluidState.is(FluidTags.WATER)) continue;
            boolean waterBelow = false;
            for (int y = Mth.floor((double)d1) - 1; y > Mth.floor((double)d1) - 3 && y > 0; --y) {
                BlockPos belowPos = new BlockPos(Mth.floor((double)d0), y, Mth.floor((double)d2));
                FluidState belowFluid = this.ghastling.level().getFluidState(belowPos);
                if (!belowFluid.isEmpty() && belowFluid.is(FluidTags.WATER)) {
                    waterBelow = true;
                    break;
                }
                if (!this.ghastling.level().getBlockState(belowPos).isAir()) break;
            }
            if (waterBelow) {
                d1 += 2.0;
            }
            validPointFound = true;
        }
        if (d1 < (double)(this.ghastling.level().getSeaLevel() + 2)) {
            d1 = this.ghastling.level().getSeaLevel() + 2 + randomsource.nextInt(2);
        }
        this.ghastling.getMoveControl().setWantedPosition(d0, d1, d2, 1.0);
    }

    private int findGroundHeight(double x, double z) {
        Level level = this.ghastling.level();
        int blockX = Mth.floor((double)x);
        int blockZ = Mth.floor((double)z);
        int startY = Mth.floor((double)this.ghastling.getY()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(blockX, y, blockZ);
            BlockState blockState = level.getBlockState(blockPos);
            if (blockState.isAir() || blockState.liquid() || (collisionShape = blockState.getCollisionShape((BlockGetter)level, blockPos)).isEmpty()) continue;
            return y + 1;
        }
        return -1;
    }
}

