/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.Ghastling;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingLookGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghastling ghastling;
    private float lastYRot = 0.0f;
    private float targetYRot = 0.0f;
    private Vec3 smoothedDirection = null;
    private static final double DIR_SMOOTHING_LEASHED = 0.08;
    private int rotationHoldTimer = 0;
    private static final int MIN_ROTATION_HOLD_TICKS = 8;
    private static final double MIN_VELOCITY_FOR_ROTATION = 0.02;
    private static final float MAX_ROTATION_SPEED_LEASHED = 2.0f;

    public GhastlingLookGoal(Ghastling ghastling) {
        this.ghastling = ghastling;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        this.lastYRot = ghastling.getYRot();
        this.targetYRot = ghastling.getYRot();
    }

    public boolean canUse() {
        return true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean isFollowing;
        boolean isLeashed = this.ghastling.isLeashed();
        Entity leashHolder = null;
        if (isLeashed) {
            leashHolder = this.ghastling.getLeashHolder();
        }
        if (isFollowing = AnchorManager.isFollowing((Entity)this.ghastling)) {
            return;
        }
        if (isLeashed && leashHolder != null) {
            this.tickLeashed(leashHolder);
        } else if (isFollowing) {
            this.lastYRot = this.ghastling.getYRot();
            this.targetYRot = this.ghastling.getYRot();
        } else {
            this.tickNormal();
            this.smoothedDirection = null;
            this.rotationHoldTimer = 0;
        }
    }

    private void tickNormal() {
        Vec3 delta = this.ghastling.getDeltaMovement();
        if (delta.horizontalDistanceSqr() > 1.0E-6) {
            this.targetYRot = -((float)Mth.atan2((double)delta.x, (double)delta.z)) * 57.295776f;
        }
        float rotationDiff = Mth.wrapDegrees((float)(this.targetYRot - this.lastYRot));
        float rotationStep = Mth.clamp((float)rotationDiff, (float)-10.0f, (float)10.0f);
        this.lastYRot = Mth.wrapDegrees((float)(this.lastYRot + rotationStep));
        this.ghastling.setYRot(this.lastYRot);
        this.ghastling.yBodyRot = this.ghastling.getYRot();
    }

    private void tickLeashed(Entity leashHolder) {
        boolean shouldUpdateDirection;
        Vec3 motionVector = this.ghastling.getDeltaMovement();
        double horizontalSpeed = motionVector.horizontalDistance();
        boolean bl = shouldUpdateDirection = horizontalSpeed > 0.02 || this.rotationHoldTimer <= 0;
        if (shouldUpdateDirection) {
            this.rotationHoldTimer = 8;
            Vec3 toLeashHolder = leashHolder.position().subtract(this.ghastling.position());
            Vec3 directionVector = horizontalSpeed > 0.01 ? motionVector.normalize().scale(0.7).add(toLeashHolder.normalize().scale(0.3)) : toLeashHolder;
            if (directionVector.horizontalDistanceSqr() > 1.0E-6) {
                directionVector = directionVector.normalize();
                this.smoothedDirection = this.smoothedDirection == null ? directionVector : this.smoothedDirection.scale(0.92).add(directionVector.scale(0.08)).normalize();
                this.targetYRot = -((float)Mth.atan2((double)this.smoothedDirection.x, (double)this.smoothedDirection.z)) * 57.295776f;
            }
        } else {
            --this.rotationHoldTimer;
        }
        float rotationDiff = Mth.wrapDegrees((float)(this.targetYRot - this.lastYRot));
        float rotationStep = Mth.clamp((float)rotationDiff, (float)-2.0f, (float)2.0f);
        this.lastYRot = Mth.wrapDegrees((float)(this.lastYRot + rotationStep));
        this.ghastling.setYRot(this.lastYRot);
        this.ghastling.yBodyRot = this.ghastling.getYRot();
    }
}

