/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.goals;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastlingFollowPlayerWithSnowballGoal
extends Goal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Ghast ghastling;
    private Player player;
    private final double speedModifier;
    private final float startDistance;
    private double smoothedTargetY = Double.NaN;
    private static final double VERTICAL_SMOOTHING = 0.1;
    private boolean wasHoldingSnowball = false;
    private static final double HEIGHT_ABOVE_PLAYER = 1.5;
    private static final int POSITION_CHANGE_INTERVAL = 100;
    private int positionChangeTimer = 0;
    private int verticalPositionMode = 0;
    private static final float[] VERTICAL_OFFSETS = new float[]{3.0f, 1.0f};

    public GhastlingFollowPlayerWithSnowballGoal(Ghast ghastling, double speedModifier, float startDistance) {
        this.ghastling = ghastling;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        boolean shouldFollow;
        this.player = this.ghastling.level().getNearestPlayer((Entity)this.ghastling, (double)(this.startDistance * 3.0f));
        if (this.player == null) {
            if (this.wasHoldingSnowball) {
                this.wasHoldingSnowball = false;
                AnchorManager.stopFollowing((Entity)this.ghastling);
                LOGGER.debug("Ghastling stopped following - player not found");
            }
            return false;
        }
        boolean holdingSnowball = this.isHoldingSnowball(this.player);
        if (holdingSnowball && !this.wasHoldingSnowball) {
            AnchorManager.markAsFollowing((Entity)this.ghastling);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.getX(), this.player.getY(), this.player.getZ());
            LOGGER.debug("Ghastling started following - player took out snowball");
        } else if (!holdingSnowball && this.wasHoldingSnowball) {
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - player put away snowball");
        }
        this.wasHoldingSnowball = holdingSnowball;
        boolean bl = shouldFollow = holdingSnowball && this.ghastling.distanceToSqr((Entity)this.player) > 9.0;
        if (holdingSnowball && !shouldFollow && AnchorManager.hasAnchor((Entity)this.ghastling)) {
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.getX(), this.player.getY(), this.player.getZ());
            double distanceSq = this.ghastling.distanceToSqr((Entity)this.player);
            if (distanceSq > 256.0 && AnchorManager.canUpdateAnchor((Entity)this.ghastling)) {
                AnchorManager.createTemporaryAnchor((Entity)this.ghastling, this.player.getX(), this.player.getY(), this.player.getZ());
                LOGGER.debug("Created temporary anchor for Ghastling");
            }
        }
        return shouldFollow;
    }

    public boolean canContinueToUse() {
        return this.isHoldingSnowball(this.player) && this.ghastling.distanceToSqr((Entity)this.player) > 9.0 && this.player.isAlive();
    }

    private boolean isHoldingSnowball(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        return mainHand.is(Items.SNOWBALL) || offHand.is(Items.SNOWBALL);
    }

    public void stop() {
        this.player = null;
        if (this.wasHoldingSnowball) {
            this.wasHoldingSnowball = false;
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - goal stopped");
        }
        this.smoothedTargetY = Double.NaN;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        double heightDiff;
        double minHeight;
        int groundY;
        double targetY;
        boolean currentlyHoldingSnowball = this.isHoldingSnowball(this.player);
        if (!currentlyHoldingSnowball && this.wasHoldingSnowball) {
            this.wasHoldingSnowball = false;
            AnchorManager.stopFollowing((Entity)this.ghastling);
            LOGGER.debug("Ghastling stopped following - player put away snowball during tick");
            return;
        }
        this.wasHoldingSnowball = currentlyHoldingSnowball;
        if (currentlyHoldingSnowball) {
            AnchorManager.markAsFollowing((Entity)this.ghastling);
            AnchorManager.updateLastPlayerPosition((Entity)this.ghastling, this.player.getX(), this.player.getY(), this.player.getZ());
        }
        double dx = this.player.getX() - this.ghastling.getX();
        double dz = this.player.getZ() - this.ghastling.getZ();
        float targetYaw = -((float)Mth.atan2((double)dx, (double)dz)) * 57.295776f;
        this.ghastling.setYRot(targetYaw);
        this.ghastling.yBodyRot = this.ghastling.getYRot();
        ++this.positionChangeTimer;
        if (this.positionChangeTimer >= 100) {
            this.verticalPositionMode = this.ghastling.getRandom().nextInt(2);
            this.positionChangeTimer = 0;
            LOGGER.debug("Ghastling position changed to mode: {}", (Object)this.verticalPositionMode);
            this.smoothedTargetY = Double.NaN;
        }
        if ((targetY = (groundY = this.findGroundHeight(this.player.getX(), this.player.getZ())) != -1 ? (double)groundY + 1.0 + (double)this.ghastling.getRandom().nextFloat() * 1.0 : this.player.getY() + (double)(this.verticalPositionMode == 0 ? 2.0f : 0.5f)) < (minHeight = (double)(this.ghastling.level().getSeaLevel() + 2))) {
            targetY = minHeight;
        }
        if (Double.isNaN(this.smoothedTargetY)) {
            this.smoothedTargetY = this.ghastling.getY();
        }
        double verticalSpeed = (heightDiff = Math.abs(targetY - this.ghastling.getY())) > 8.0 ? 0.2 : (heightDiff > 4.0 ? 0.1 : 0.05);
        this.smoothedTargetY += (targetY - this.smoothedTargetY) * verticalSpeed;
        if (this.ghastling.distanceToSqr((Entity)this.player) > 36.0) {
            double offsetX = this.player.getX() + (double)(this.ghastling.getRandom().nextFloat() * 4.0f - 2.0f);
            double offsetY = this.smoothedTargetY;
            double offsetZ = this.player.getZ() + (double)(this.ghastling.getRandom().nextFloat() * 4.0f - 2.0f);
            this.ghastling.getMoveControl().setWantedPosition(offsetX, offsetY, offsetZ, this.speedModifier);
        } else {
            double dist = Math.sqrt(this.ghastling.distanceToSqr((Entity)this.player));
            if (dist < 4.0) {
                Vec3 moveAwayVec = new Vec3(this.ghastling.getX() - this.player.getX(), 0.0, this.ghastling.getZ() - this.player.getZ()).normalize();
                this.ghastling.getMoveControl().setWantedPosition(this.ghastling.getX() + moveAwayVec.x * 1.5, this.smoothedTargetY, this.ghastling.getZ() + moveAwayVec.z * 1.5, 0.8);
            } else {
                this.ghastling.getMoveControl().setWantedPosition(this.ghastling.getX(), this.smoothedTargetY, this.ghastling.getZ(), 0.4);
            }
        }
    }

    private int findGroundHeight(double x, double z) {
        Level level = this.ghastling.level();
        int blockX = Mth.floor((double)x);
        int blockZ = Mth.floor((double)z);
        int startY = Mth.floor((double)this.ghastling.getY()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(blockX, y, blockZ);
            BlockState blockState = level.getBlockState(blockPos);
            if (blockState.isAir() || blockState.liquid() || (collisionShape = blockState.getCollisionShape((BlockGetter)level, blockPos)).isEmpty()) continue;
            return y + 1;
        }
        return -1;
    }
}

