/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastRidingComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final GhastPlatformComponent platformComponent;
    private static final boolean DEBUG_LOGGING = false;

    public GhastRidingComponent(HappyGhast owner, GhastDataComponent dataComponent, GhastPlatformComponent platformComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.platformComponent = platformComponent;
    }

    public boolean canAddPassenger(Entity passenger) {
        boolean hasSaddle = this.dataComponent.isSaddled();
        int maxPassengers = this.owner.getMaxPassengers();
        int currentPassengers = this.owner.getPassengers().size();
        boolean canAdd = hasSaddle && currentPassengers < maxPassengers;
        return canAdd;
    }

    public void handlePassengerRemoval(Entity passenger) {
        if (!this.owner.level().isClientSide && passenger instanceof Player) {
            Player player = (Player)passenger;
            this.owner.playGogglesUpSound();
            AnchorManager.setAnchor((Entity)this.owner, player.getX(), player.getY(), player.getZ());
            AnchorManager.updateLastPlayerPosition((Entity)this.owner, player.getX(), player.getY(), player.getZ());
            if (!this.platformComponent.isActive()) {
                if (this.owner.isLeashed()) {
                    Entity leashHolder = this.owner.getLeashHolder();
                    Vec3 playerPos = player.position();
                    if (leashHolder instanceof LeashFenceKnotEntity) {
                        leashHolder.discard();
                    }
                    this.owner.dropLeash(true, true);
                }
                this.platformComponent.activate();
            }
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.owner.getPassengers();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity firstPassenger = (Entity)passengers.get(0);
        if (firstPassenger instanceof Player) {
            Player player = (Player)firstPassenger;
            return player;
        }
        if (firstPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)firstPassenger;
            return livingEntity;
        }
        return null;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        double zOffset;
        double xOffset;
        if (!this.owner.hasPassenger(passenger)) {
            return;
        }
        double baseYOffset = 3.55;
        List passengers = this.owner.getPassengers();
        int passengerIndex = passengers.indexOf(passenger);
        float ownerYawRad = -this.owner.getYRot() * ((float)Math.PI / 180);
        if (passengerIndex == 0) {
            xOffset = 0.0;
            zOffset = 2.0;
        } else if (passengerIndex == 1) {
            xOffset = 2.0;
            zOffset = 0.0;
        } else if (passengerIndex == 2) {
            xOffset = 0.0;
            zOffset = -2.0;
        } else {
            xOffset = -2.0;
            zOffset = 0.0;
        }
        double rotatedX = xOffset * Math.cos(ownerYawRad) + zOffset * Math.sin(ownerYawRad);
        double rotatedZ = zOffset * Math.cos(ownerYawRad) - xOffset * Math.sin(ownerYawRad);
        double finalX = this.owner.getX() + rotatedX;
        double finalY = this.owner.getY() + baseYOffset;
        double finalZ = this.owner.getZ() + rotatedZ;
        moveFunction.accept(passenger, finalX, finalY, finalZ);
        if (passengerIndex == 0 && this.owner.level().isClientSide()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (passenger == minecraft.player) {
                this.owner.setYRot(passenger.getYRot());
                this.owner.setXRot(passenger.getXRot() * 0.5f);
                this.owner.yBodyRot = this.owner.getYRot();
                this.owner.yHeadRot = this.owner.getYRot();
            }
        } else if (passengerIndex == 0) {
            passenger.setYRot(this.owner.getYRot());
            passenger.setYBodyRot(this.owner.getYRot());
            if (passenger instanceof LivingEntity) {
                LivingEntity livingPassenger = (LivingEntity)passenger;
                livingPassenger.yHeadRot = this.owner.getYRot();
            }
        }
    }

    protected void clampPassengerRotation(Entity passenger) {
        if (passenger != this.getControllingPassenger()) {
            return;
        }
        if (this.owner.level().isClientSide()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (passenger == minecraft.player) {
                return;
            }
        }
        passenger.setYBodyRot(this.owner.getYRot());
        float deltaYaw = Mth.wrapDegrees((float)(passenger.getYRot() - this.owner.getYRot()));
        float maxAngleDiff = 120.0f;
        float clampedDeltaYaw = Mth.clamp((float)deltaYaw, (float)(-maxAngleDiff), (float)maxAngleDiff);
        passenger.yRotO += clampedDeltaYaw - deltaYaw;
        passenger.setYRot(this.owner.getYRot() + clampedDeltaYaw);
        passenger.setYHeadRot(passenger.getYRot());
    }

    public void handlePassengerTurned(Entity passenger) {
        if (passenger == this.getControllingPassenger()) {
            if (passenger instanceof LivingEntity) {
                LivingEntity livingPassenger = (LivingEntity)passenger;
                livingPassenger.yBodyRot = this.owner.getYRot();
            }
            this.clampPassengerRotation(passenger);
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        double dismountY = this.owner.getY() + 3.65 + 0.5;
        return new Vec3(this.owner.getX(), dismountY, this.owner.getZ());
    }
}

