/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.GhastPlatformEntity;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastPlatformComponent {
    public static final double PLATFORM_Y_OFFSET = 3.65;
    private static final double STANDING_CHECK_RADIUS = 2.1;
    private static final double STANDING_CHECK_HEIGHT = 2.0;
    private static final int PLATFORM_GRACE_PERIOD_DURATION = 10;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG_LOGGING = false;
    private final HappyGhast owner;
    private final Level level;
    private boolean isPlatformActive = false;
    @Nullable
    private UUID platformUUID = null;
    private int platformGracePeriodTicks = 0;

    public GhastPlatformComponent(HappyGhast owner) {
        this.owner = owner;
        this.level = owner.level();
    }

    public boolean isActive() {
        return this.isPlatformActive;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isPlatformActive) {
            double checkY = this.owner.getY() + 3.65;
            AABB checkZone = new AABB(this.owner.getX() - 2.1, checkY - 0.1, this.owner.getZ() - 2.1, this.owner.getX() + 2.1, checkY + 2.0, this.owner.getZ() + 2.1);
            List playersAbove = this.level.getEntitiesOfClass(Player.class, checkZone, player -> player.getVehicle() != this.owner && player.getY() >= checkY - 0.05);
            if (!playersAbove.isEmpty()) {
                if (this.owner.isLeashed()) {
                    this.owner.dropLeash(true, false);
                }
                this.activate();
                return;
            }
        }
        if (!this.isPlatformActive) {
            if (this.platformUUID != null) {
                this.platformUUID = null;
            }
            this.platformGracePeriodTicks = 0;
            return;
        }
        GhastPlatformEntity platform = this.findPlatformEntity();
        if (platform == null) {
            LOGGER.error("[PlatformComponent] Platform is active, but entity not found! Deactivating. Ghast: {}", (Object)this.owner.getUUID());
            this.deactivate();
            return;
        }
        platform.setPos(this.owner.getX(), this.owner.getY() + 3.65, this.owner.getZ());
        platform.setDeltaMovement(Vec3.ZERO);
        if (this.platformGracePeriodTicks > 0) {
            --this.platformGracePeriodTicks;
        } else if (!this.isAnyoneStandingOnTop()) {
            this.deactivate();
        }
    }

    public void activate() {
        if (this.level.isClientSide() || this.isPlatformActive) {
            return;
        }
        this.isPlatformActive = true;
        this.platformGracePeriodTicks = 10;
        GhastPlatformEntity platform = new GhastPlatformEntity(this.level, this.owner.getX(), this.owner.getY() + 3.65, this.owner.getZ(), this.owner);
        if (this.level.addFreshEntity((Entity)platform)) {
            this.platformUUID = platform.getUUID();
        } else {
            LOGGER.error("[PlatformComponent] Failed to spawn GhastPlatformEntity! Ghast: {}", (Object)this.owner.getUUID());
            this.isPlatformActive = false;
            this.platformGracePeriodTicks = 0;
            this.platformUUID = null;
        }
    }

    public void deactivate() {
        if (this.level.isClientSide() || !this.isPlatformActive) {
            return;
        }
        this.isPlatformActive = false;
        this.platformGracePeriodTicks = 0;
        this.removePlatformEntity();
    }

    @Nullable
    private GhastPlatformEntity findPlatformEntity() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.platformUUID != null) {
                Entity entity = serverLevel.getEntity(this.platformUUID);
                if (entity instanceof GhastPlatformEntity) {
                    GhastPlatformEntity platformEntity = (GhastPlatformEntity)entity;
                    if (platformEntity.getOwnerUUID().isPresent() && platformEntity.getOwnerUUID().get().equals(this.owner.getUUID())) {
                        return platformEntity;
                    }
                    LOGGER.error("[PlatformComponent] Found GhastPlatformEntity, but owner UUID does not match. Disconnecting platform.");
                    this.platformUUID = null;
                    this.isPlatformActive = false;
                    return null;
                }
                if (entity != null) {
                    LOGGER.error("[PlatformComponent] Found entity with platform UUID, but it's not a GhastPlatformEntity!");
                    this.platformUUID = null;
                    this.isPlatformActive = false;
                    return null;
                }
            }
        }
        if (this.platformUUID != null && !(this.level instanceof ServerLevel)) {
            return null;
        }
        if (this.platformUUID != null) {
            LOGGER.error("[PlatformComponent] Platform UUID is set, but no entity found in level. Assuming removed.");
            this.platformUUID = null;
            this.isPlatformActive = false;
            return null;
        }
        return null;
    }

    private void removePlatformEntity() {
        if (this.level.isClientSide()) {
            return;
        }
        GhastPlatformEntity platform = this.findPlatformEntity();
        if (platform != null) {
            platform.discard();
        }
        this.platformUUID = null;
    }

    private boolean isAnyoneStandingOnTop() {
        if (!this.isPlatformActive || this.level.isClientSide()) {
            return false;
        }
        double platformBaseY = this.owner.getY() + 3.65;
        AABB checkZone = new AABB(this.owner.getX() - 2.1, platformBaseY - 0.1, this.owner.getZ() - 2.1, this.owner.getX() + 2.1, platformBaseY + 2.0, this.owner.getZ() + 2.1);
        List entitiesInZone = this.level.getEntities((Entity)this.owner, checkZone, entity -> entity instanceof LivingEntity && entity.getVehicle() != this.owner && entity.getY() >= platformBaseY - 0.05 && !(entity instanceof GhastPlatformEntity));
        return !entitiesInZone.isEmpty();
    }

    public boolean shouldDisableCollisionWith(Entity otherEntity) {
        if (!this.isPlatformActive || this.level.isClientSide()) {
            return false;
        }
        if (otherEntity instanceof GhastPlatformEntity && otherEntity.getUUID().equals(this.platformUUID)) {
            return true;
        }
        if (otherEntity instanceof LivingEntity) {
            double checkStartY = this.owner.getY() + 3.65 - 0.5;
            double checkEndY = this.owner.getY() + 3.65 + 2.0 + 0.5;
            AABB collisionCheckZone = new AABB(this.owner.getX() - 2.1, checkStartY, this.owner.getZ() - 2.1, this.owner.getX() + 2.1, checkEndY, this.owner.getZ() + 2.1);
            if (collisionCheckZone.intersects(otherEntity.getBoundingBox())) {
                return true;
            }
        }
        return false;
    }

    public void onOwnerRemoved() {
        if (!this.level.isClientSide()) {
            this.removePlatformEntity();
            this.isPlatformActive = false;
            this.platformGracePeriodTicks = 0;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag platformTag = new CompoundTag();
        platformTag.putBoolean("IsActive", this.isPlatformActive);
        if (this.platformUUID != null) {
            platformTag.putUUID("PlatformUUID", this.platformUUID);
        }
        platformTag.putInt("GraceTicks", this.platformGracePeriodTicks);
        compound.put("GhastPlatformComponent", (Tag)platformTag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("GhastPlatformComponent", 10)) {
            CompoundTag platformTag = compound.getCompound("GhastPlatformComponent");
            this.isPlatformActive = platformTag.getBoolean("IsActive");
            if (platformTag.hasUUID("PlatformUUID")) {
                this.platformUUID = platformTag.getUUID("PlatformUUID");
            } else {
                this.platformUUID = null;
                if (this.isPlatformActive) {
                    this.isPlatformActive = false;
                }
            }
            this.platformGracePeriodTicks = platformTag.getInt("GraceTicks");
        } else {
            this.isPlatformActive = false;
            this.platformUUID = null;
            this.platformGracePeriodTicks = 0;
        }
    }
}

