/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.entity.components.GhastRidingComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastMovementComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final GhastPlatformComponent platformComponent;
    private final GhastRidingComponent ridingComponent;
    public static float SPEED_MULTIPLIER = 1.0f;
    private static final float BASE_FORWARD_SPEED = 0.18f;
    private static final float ORIGINAL_FORWARD_SPEED = 0.3f;
    private static final float MAX_VERTICAL_SPEED = 0.3f;
    private static final double MIN_SPEED_THRESHOLD = 0.001;
    private int rideSoundCounter = 0;
    private static final int RIDE_SOUND_INTERVAL = 80;
    private static final float ACCELERATION_RATE = 0.1f;
    private Vec3 targetVelocity = Vec3.ZERO;

    public GhastMovementComponent(HappyGhast owner, GhastDataComponent dataComponent, GhastPlatformComponent platformComponent, GhastRidingComponent ridingComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.platformComponent = platformComponent;
        this.ridingComponent = ridingComponent;
    }

    private float getSpeedMultiplier() {
        return this.owner.getSpeedMultiplier();
    }

    public void handleTravel(Vec3 travelVector) {
        if (!this.owner.isAlive()) {
            return;
        }
        if (!this.owner.level().isClientSide() && this.platformComponent.isActive()) {
            this.targetVelocity = Vec3.ZERO;
            this.owner.setDeltaMovement(Vec3.ZERO);
            this.owner.getNavigation().stop();
            return;
        }
        LivingEntity controller = this.ridingComponent.getControllingPassenger();
        if (this.owner.isVehicle() && controller instanceof Player) {
            Player player = (Player)controller;
            this.handleRiderControlledMovement(player);
            return;
        }
    }

    private void handleRiderControlledMovement(Player player) {
        boolean hasVerticalInput;
        boolean isLocalPlayer;
        float speedMultiplier = this.getSpeedMultiplier();
        boolean bl = isLocalPlayer = this.owner.level().isClientSide() && Minecraft.getInstance().player == player;
        if (isLocalPlayer) {
            this.owner.setYRot(player.getYRot());
            this.owner.setXRot(player.getXRot() * 0.5f);
            this.owner.yHeadRot = this.owner.yBodyRot = this.owner.getYRot();
        } else {
            float yRotDiff = player.getYRot() - this.owner.getYRot();
            if (yRotDiff > 180.0f) {
                yRotDiff -= 360.0f;
            }
            if (yRotDiff < -180.0f) {
                yRotDiff += 360.0f;
            }
            float smoothFactor = this.owner.level().isClientSide() ? 0.5f : 0.3f;
            this.owner.setYRot(this.owner.getYRot() + yRotDiff * smoothFactor);
            this.owner.setXRot(player.getXRot() * 0.5f);
            this.owner.yHeadRot = this.owner.yBodyRot = this.owner.getYRot();
        }
        float forwardInput = player.zza;
        float sideInput = player.xxa;
        double verticalMotion = 0.0;
        if (this.dataComponent.isAscending()) {
            verticalMotion = 0.3f * speedMultiplier;
        } else if (this.dataComponent.isDescending() || player.isShiftKeyDown()) {
            verticalMotion = -0.3f * speedMultiplier;
        }
        boolean hasHorizontalInput = forwardInput != 0.0f || sideInput != 0.0f;
        boolean bl2 = hasVerticalInput = verticalMotion != 0.0;
        if (!this.owner.level().isClientSide() && (hasHorizontalInput || hasVerticalInput)) {
            ++this.rideSoundCounter;
            if (this.rideSoundCounter >= 80) {
                this.owner.playRideSound();
                this.rideSoundCounter = 0;
            }
        }
        if (hasHorizontalInput || hasVerticalInput) {
            float accelerationFactor;
            double yawRadians = Math.toRadians(-this.owner.getYRot());
            double motionX = 0.0;
            double motionZ = 0.0;
            if (forwardInput != 0.0f) {
                motionX += Math.sin(yawRadians) * (double)forwardInput * (double)0.18f * (double)speedMultiplier;
                motionZ += Math.cos(yawRadians) * (double)forwardInput * (double)0.18f * (double)speedMultiplier;
            }
            if (sideInput != 0.0f) {
                motionX += Math.sin(yawRadians + 1.5707963267948966) * (double)sideInput * (double)0.18f * (double)speedMultiplier;
                motionZ += Math.cos(yawRadians + 1.5707963267948966) * (double)sideInput * (double)0.18f * (double)speedMultiplier;
            }
            this.targetVelocity = new Vec3(motionX, verticalMotion, motionZ);
            Vec3 currentVelocity = this.owner.getDeltaMovement();
            float f = accelerationFactor = isLocalPlayer ? 0.15f : 0.1f;
            if (speedMultiplier > 1.0f) {
                accelerationFactor *= Math.min(speedMultiplier, 5.0f) / 2.0f;
            }
            Vec3 newVelocity = currentVelocity.add((this.targetVelocity.x - currentVelocity.x) * (double)accelerationFactor, (this.targetVelocity.y - currentVelocity.y) * (double)accelerationFactor, (this.targetVelocity.z - currentVelocity.z) * (double)accelerationFactor);
            this.owner.setDeltaMovement(newVelocity);
            Vec3 fallbackMovement = new Vec3((double)(sideInput * speedMultiplier * 0.18f / 0.3f), verticalMotion, (double)(forwardInput * speedMultiplier * 0.18f / 0.3f));
            this.owner.applyControlledMovement(fallbackMovement);
        } else {
            double smoothingFactor;
            double factor;
            this.targetVelocity = Vec3.ZERO;
            Vec3 currentVelocity = this.owner.getDeltaMovement();
            Vec3 newVelocity = currentVelocity.multiply(factor = 1.0 - (smoothingFactor = 0.06), factor, factor);
            if (newVelocity.lengthSqr() < 0.001) {
                newVelocity = Vec3.ZERO;
            }
            this.owner.setDeltaMovement(newVelocity);
            this.owner.applyControlledMovement(Vec3.ZERO);
        }
    }

    public boolean isPushable() {
        return this.owner.level().isClientSide() || !this.platformComponent.isActive();
    }

    public boolean canCollideWith(Entity otherEntity) {
        return !this.platformComponent.shouldDisableCollisionWith(otherEntity);
    }
}

