/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class GhastLeashComponent {
    private final HappyGhast owner;
    private static final double MAX_LEASH_DISTANCE = 5.0;
    private static final double MAX_LEASH_DISTANCE_SQR = 25.0;
    private static final double LEASH_PULL_STRENGTH = 0.03;
    private static final double LEASH_VERTICAL_PULL_STRENGTH = 0.02;
    private static final double MOTION_DAMPING = 0.9;
    private static final double VERTICAL_DAMPING = 0.95;
    private Vec3 smoothedPullForce = Vec3.ZERO;
    private static final double PULL_FORCE_SMOOTHING = 0.2;
    private static final double COMFORT_ZONE_RATIO = 0.8;
    private static final double COMFORT_ZONE_SQR = 20.0;

    public GhastLeashComponent(HappyGhast owner) {
        this.owner = owner;
    }

    public InteractionResult handleLeashInteraction(Player player, InteractionHand hand, GhastPlatformComponent platformComponent) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.owner.hasPassenger((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (itemstack.is(Items.LEAD)) {
            if (this.owner.isSaddled()) {
                return InteractionResult.CONSUME;
            }
            if (!(this.owner.isLeashed() || this.owner.isVehicle() || platformComponent != null && platformComponent.isActive())) {
                if (!this.owner.level().isClientSide()) {
                    this.owner.setLeashedTo((Entity)player, true);
                    this.owner.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)player);
                }
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.owner.level().playSound(null, (Entity)this.owner, SoundEvents.LEASH_KNOT_PLACE, SoundSource.NEUTRAL, 0.5f, 1.0f);
                return InteractionResult.sidedSuccess((boolean)this.owner.level().isClientSide());
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canBeLeashed(Player player, GhastPlatformComponent platformComponent) {
        return !this.owner.isLeashed() && !this.owner.isVehicle() && !this.owner.hasPassenger((Entity)player) && (platformComponent == null || !platformComponent.isActive());
    }

    public void onLeashDropped(boolean broadcast, boolean dropItem) {
        this.smoothedPullForce = Vec3.ZERO;
    }

    public void tickLeash() {
        if (!this.owner.level().isClientSide() && this.owner.isLeashed()) {
            Entity leashHolder = this.owner.getLeashHolder();
            if (leashHolder != null) {
                double distanceSqr = this.owner.distanceToSqr(leashHolder);
                Vec3 currentDelta = this.owner.getDeltaMovement();
                Vec3 dampedDelta = currentDelta.multiply(0.9, 0.95, 0.9);
                if (distanceSqr > 20.0) {
                    Vec3 currentPos = this.owner.position();
                    Vec3 holderPos = leashHolder.position();
                    Vec3 vectorToHolder = holderPos.subtract(currentPos);
                    double currentDist = Math.sqrt(distanceSqr);
                    double maxDist = Math.sqrt(25.0);
                    double comfortDist = Math.sqrt(20.0);
                    double overshootRatio = Math.min(1.0, (currentDist - comfortDist) / (maxDist - comfortDist));
                    double pullStrengthFactor = overshootRatio * overshootRatio * 0.03;
                    Vec3 rawPullForce = vectorToHolder.normalize().scale(pullStrengthFactor);
                    this.smoothedPullForce = this.smoothedPullForce == Vec3.ZERO ? rawPullForce : this.smoothedPullForce.scale(0.8).add(rawPullForce.scale(0.2));
                    double verticalDiff = holderPos.y - currentPos.y;
                    Vec3 extraVerticalForce = Vec3.ZERO;
                    if (Math.abs(verticalDiff) > 1.0) {
                        double verticalRatio = Math.min(Math.abs(verticalDiff) / 10.0, 1.0);
                        double yPullStrength = verticalRatio * verticalRatio * 0.02;
                        extraVerticalForce = new Vec3(0.0, Math.signum(verticalDiff) * yPullStrength, 0.0);
                    }
                    Vec3 newDelta = dampedDelta.add(this.smoothedPullForce).add(extraVerticalForce);
                    double maxSpeed = 0.3;
                    if (newDelta.length() > maxSpeed) {
                        newDelta = newDelta.normalize().scale(maxSpeed);
                    }
                    this.owner.setDeltaMovement(newDelta);
                } else {
                    this.owner.setDeltaMovement(dampedDelta);
                    if (this.smoothedPullForce != Vec3.ZERO) {
                        this.smoothedPullForce = this.smoothedPullForce.scale(0.8);
                        if (this.smoothedPullForce.lengthSqr() < 1.0E-4) {
                            this.smoothedPullForce = Vec3.ZERO;
                        }
                    }
                }
            }
        } else {
            this.smoothedPullForce = Vec3.ZERO;
        }
    }
}

