/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.container.GhastContainer;
import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.item.HarnessItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastInventoryComponent
implements Container {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;
    private final GhastDataComponent dataComponent;
    private final SimpleContainer inventory;
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();
    private static final boolean DEBUG_LOGGING = false;
    private static final String CUSTOM_HARNESS_ID_KEY = "CustomHarnessId";
    private static final String HAS_CUSTOM_SADDLE_TEXTURE_KEY = "HasCustomSaddleTexture";
    private static final String HAS_CUSTOM_GLASSES_TEXTURE_KEY = "HasCustomGlassesTexture";
    private static final String HAS_CUSTOM_ACCESSORY_TEXTURE_KEY = "HasCustomAccessoryTexture";

    public GhastInventoryComponent(HappyGhast owner, GhastDataComponent dataComponent) {
        this.owner = owner;
        this.dataComponent = dataComponent;
        this.inventory = new SimpleContainer(1);
        this.syncInventoryWithState();
        this.inventory.addListener(this::onInventoryChanged);
    }

    public void openInventory(Player player) {
        if (!this.owner.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.owner.isVehicle() && this.owner.hasPassenger((Entity)player)) {
                this.syncInventoryWithState();
                SimpleMenuProvider provider = new SimpleMenuProvider((windowId, playerInventory, p) -> new GhastContainer(windowId, playerInventory, this, this.owner), (Component)Component.translatable((String)"container.happyghastmod.ghast"));
                serverPlayer.openMenu((MenuProvider)provider, buffer -> buffer.writeInt(this.owner.getId()));
            }
        }
    }

    public boolean canUseInventory(Player player) {
        return this.owner.isVehicle() && this.owner.hasPassenger((Entity)player);
    }

    private void onInventoryChanged(Container container) {
        ItemStack harnessStack = container.getItem(0);
        if (harnessStack.isEmpty()) {
            if (this.dataComponent.isSaddled()) {
                this.dataComponent.setSaddled(false);
                this.dataComponent.setHarnessColor("default");
            }
        } else {
            Item item = harnessStack.getItem();
            if (item instanceof HarnessItem) {
                HarnessItem harnessItem = (HarnessItem)item;
                this.dataComponent.setSaddled(true);
                Optional<String> customHarnessIdOpt = GhastInventoryComponent.getCustomHarnessIdFromStack(harnessStack);
                if (customHarnessIdOpt.isPresent()) {
                    this.dataComponent.setHarnessColor("custom:" + customHarnessIdOpt.get());
                } else {
                    this.dataComponent.setHarnessColor(harnessItem.getColor());
                }
            }
        }
    }

    private static Optional<String> getCustomHarnessIdFromStack(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData.copyTag().contains(CUSTOM_HARNESS_ID_KEY, 8)) {
            return Optional.of(customData.copyTag().getString(CUSTOM_HARNESS_ID_KEY));
        }
        return Optional.empty();
    }

    private static void setCustomHarnessDataOnStack(ItemStack stack, String customId, CustomHarnessManager.CustomHarnessData data) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putString(CUSTOM_HARNESS_ID_KEY, customId);
        if (data != null) {
            tag.putBoolean(HAS_CUSTOM_SADDLE_TEXTURE_KEY, data.hasSaddleTexture());
            tag.putBoolean(HAS_CUSTOM_GLASSES_TEXTURE_KEY, data.hasGlassesTexture());
            tag.putBoolean(HAS_CUSTOM_ACCESSORY_TEXTURE_KEY, data.hasAccessoryTexture());
        } else {
            tag.remove(HAS_CUSTOM_SADDLE_TEXTURE_KEY);
            tag.remove(HAS_CUSTOM_GLASSES_TEXTURE_KEY);
            tag.remove(HAS_CUSTOM_ACCESSORY_TEXTURE_KEY);
        }
        if (data != null && data.getName() != null && !data.getName().isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)data.getName()).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        } else {
            stack.remove(DataComponents.CUSTOM_NAME);
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public void syncInventoryWithState() {
        if (this.dataComponent.isSaddled() && this.inventory.getItem(0).isEmpty()) {
            String color = this.dataComponent.getHarnessColor();
            if (color != null && color.startsWith("custom:")) {
                String customId = color.substring("custom:".length());
                CustomHarnessManager.CustomHarnessData data = CustomHarnessManager.getCustomHarnessData(customId);
                boolean found = false;
                for (Item item : BuiltInRegistries.ITEM) {
                    if (!(item instanceof HarnessItem)) continue;
                    ItemStack tempStack = new ItemStack((ItemLike)item);
                    GhastInventoryComponent.setCustomHarnessDataOnStack(tempStack, customId, data);
                    this.inventory.setItem(0, tempStack);
                    found = true;
                    break;
                }
                if (!found) {
                    for (Item item : BuiltInRegistries.ITEM) {
                        if (!(item instanceof HarnessItem)) continue;
                        ItemStack baseStack = new ItemStack((ItemLike)item);
                        GhastInventoryComponent.setCustomHarnessDataOnStack(baseStack, customId, null);
                        this.inventory.setItem(0, baseStack);
                        break;
                    }
                }
            } else if (color != null) {
                for (Item item : BuiltInRegistries.ITEM) {
                    HarnessItem harnessItem;
                    if (!(item instanceof HarnessItem) || !(harnessItem = (HarnessItem)item).getColor().equals(color)) continue;
                    this.inventory.setItem(0, new ItemStack((ItemLike)item));
                    break;
                }
            }
        } else if (!this.dataComponent.isSaddled() && !this.inventory.getItem(0).isEmpty()) {
            this.inventory.setItem(0, ItemStack.EMPTY);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag inventoryTag = new ListTag();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            CompoundTag savedCompoundTag;
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.putInt("Slot", i);
            Tag savedTag = stack.save(provider, (Tag)new CompoundTag());
            if (savedTag instanceof CompoundTag && !(savedCompoundTag = (CompoundTag)savedTag).isEmpty()) {
                slotTag.merge((CompoundTag)savedTag);
                GhastInventoryComponent.getCustomHarnessIdFromStack(stack).ifPresent(id -> slotTag.putString("CustomHarnessBackup", id));
                inventoryTag.add((Object)slotTag);
                continue;
            }
            LOGGER.warn("Failed to save stack in slot {} for GhastInventoryComponent: {}", (Object)i, (Object)stack);
        }
        compound.put("GhastInventory", (Tag)inventoryTag);
        if (this.dataComponent.isSaddled()) {
            compound.putString("DirectHarnessColor", this.dataComponent.getHarnessColor());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound, HolderLookup.Provider provider) {
        String color;
        ItemStack stack;
        this.inventory.clearContent();
        if (compound.contains("GhastInventory", 9)) {
            ListTag inventoryTag = compound.getList("GhastInventory", 10);
            for (int i = 0; i < inventoryTag.size(); ++i) {
                CompoundTag slotTag = inventoryTag.getCompound(i);
                int slot = slotTag.getInt("Slot");
                if (slot < 0 || slot >= this.inventory.getContainerSize()) continue;
                stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)slotTag);
                if (!stack.isEmpty()) {
                    if (slotTag.contains("CustomHarnessBackup", 8) && stack.getItem() instanceof HarnessItem) {
                        String backupId = slotTag.getString("CustomHarnessBackup");
                        if (GhastInventoryComponent.getCustomHarnessIdFromStack(stack).isEmpty()) {
                            CompoundTag nbt = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                            nbt.putString(CUSTOM_HARNESS_ID_KEY, backupId);
                            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
                        }
                    }
                    this.inventory.setItem(slot, stack);
                    continue;
                }
                LOGGER.warn("Failed to load stack from NBT for slot {} in GhastInventoryComponent", (Object)slot);
            }
        }
        if (this.inventory.getItem(0).isEmpty() && compound.contains("DirectHarnessColor", 8) && (color = compound.getString("DirectHarnessColor")).startsWith("custom:")) {
            String customId = color.substring("custom:".length());
            for (Item item : BuiltInRegistries.ITEM) {
                if (!(item instanceof HarnessItem)) continue;
                stack = new ItemStack((ItemLike)item);
                CompoundTag nbt = new CompoundTag();
                nbt.putString(CUSTOM_HARNESS_ID_KEY, customId);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
                this.inventory.setItem(0, stack);
                LOGGER.debug("Restored custom harness item from DirectHarnessColor: {}", (Object)customId);
                break;
            }
        }
        if (this.inventory.getItem(0).isEmpty()) {
            this.onInventoryChanged((Container)this.inventory);
        }
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public void setChanged() {
        this.inventory.setChanged();
        for (ContainerListener listener : this.listeners) {
            listener.containerChanged((Container)this);
        }
    }

    public boolean stillValid(Player player) {
        return this.owner != null && this.owner.isAlive() && this.owner.distanceTo((Entity)player) < 8.0f && this.canUseInventory(player);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public void addListener(ContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }
}

