/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity.components;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastInventoryComponent;
import dev.nweaver.happyghastmod.entity.components.GhastLeashComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.item.HarnessItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastInteractionComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HappyGhast owner;

    public GhastInteractionComponent(HappyGhast owner) {
        this.owner = owner;
    }

    private GhastDataComponent getDataComponent() {
        return this.owner.getDataComponent();
    }

    private GhastLeashComponent getLeashComponent() {
        return this.owner.getLeashComponent();
    }

    private GhastPlatformComponent getPlatformComponent() {
        return this.owner.getPlatformComponent();
    }

    private GhastInventoryComponent getInventoryComponent() {
        return this.owner.getInventoryComponent();
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        Item item;
        ItemStack itemStack = player.getItemInHand(hand);
        GhastDataComponent data = this.getDataComponent();
        GhastLeashComponent leash = this.getLeashComponent();
        GhastPlatformComponent platform = this.getPlatformComponent();
        GhastInventoryComponent inventory = this.getInventoryComponent();
        if (data == null || leash == null || platform == null || inventory == null) {
            LOGGER.warn("One or more Ghast components are null during interaction for ghast {}", (Object)this.owner.getUUID());
            return InteractionResult.PASS;
        }
        boolean isClient = this.owner.level().isClientSide();
        InteractionResult leashResult = leash.handleLeashInteraction(player, hand, platform);
        if (leashResult != InteractionResult.PASS) {
            return leashResult;
        }
        if (data.isSaddled()) {
            if (itemStack.getItem() instanceof ShearsItem) {
                if (!isClient) {
                    ItemStack harnessToDrop = inventory.getItem(0).copy();
                    inventory.setItem(0, ItemStack.EMPTY);
                    this.owner.playHarnessUnequipSound();
                    itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    if (!harnessToDrop.isEmpty() && !player.getInventory().add(harnessToDrop)) {
                        player.drop(harnessToDrop, false);
                        LOGGER.warn("Player {} inventory full, dropping harness item {} at feet.", (Object)player.getName().getString(), (Object)harnessToDrop.getDisplayName().getString());
                    }
                }
                return InteractionResult.sidedSuccess((boolean)isClient);
            }
            item = itemStack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                String currentColor = data.getHarnessColor();
                if (currentColor != null && currentColor.startsWith("custom:")) {
                    return InteractionResult.PASS;
                }
                String newColor = dyeItem.getDyeColor().getName();
                if (!newColor.equals(currentColor)) {
                    if (!isClient) {
                        data.setHarnessColor(newColor);
                        inventory.syncInventoryWithState();
                        this.owner.playSound(SoundEvents.DYE_USE, 1.0f, 1.0f);
                        if (!player.getAbilities().instabuild) {
                            itemStack.shrink(1);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)isClient);
                }
            }
        }
        if (!data.isSaddled() && (item = itemStack.getItem()) instanceof HarnessItem) {
            HarnessItem harnessItem = (HarnessItem)item;
            if (!isClient) {
                inventory.setItem(0, itemStack.copy());
                this.owner.playHarnessEquipSound();
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)isClient);
        }
        if (data.isSaddled() && !player.isSecondaryUseActive() && !platform.isActive()) {
            if (!isClient && this.owner.canAddPassenger((Entity)player)) {
                player.startRiding((Entity)this.owner);
                this.owner.playGogglesDownSound();
            }
            return InteractionResult.sidedSuccess((boolean)isClient);
        }
        return InteractionResult.PASS;
    }
}

