/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.components.GhastDataComponent;
import dev.nweaver.happyghastmod.entity.components.GhastInteractionComponent;
import dev.nweaver.happyghastmod.entity.components.GhastInventoryComponent;
import dev.nweaver.happyghastmod.entity.components.GhastLeashComponent;
import dev.nweaver.happyghastmod.entity.components.GhastMovementComponent;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import dev.nweaver.happyghastmod.entity.components.GhastRidingComponent;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastFollowPlayerWithItemGoal;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastLookGoal;
import dev.nweaver.happyghastmod.entity.goals.HappyGhastRandomFloatGoal;
import dev.nweaver.happyghastmod.init.SoundInit;
import dev.nweaver.happyghastmod.network.GhastRotationSyncPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HappyGhast
extends Ghast {
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_DESCENDING_ID = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ASCENDING_ID = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_HARNESS_COLOR = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> DATA_SPEED_MULTIPLIER = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float lastSyncedYRot;
    private float lastSyncedXRot;
    private static final float ROTATION_SYNC_THRESHOLD = 2.0f;
    private static final int ROTATION_SYNC_INTERVAL = 2;
    private int rotationSyncCooldown = 0;
    private GhastDataComponent dataComponent;
    private GhastLeashComponent leashComponent;
    private GhastPlatformComponent platformComponent;
    private GhastRidingComponent ridingComponent;
    private GhastInteractionComponent interactionComponent;
    private GhastMovementComponent movementComponent;
    private GhastInventoryComponent inventoryComponent;
    private float targetServerYRot;
    private float targetServerXRot;
    private float targetServerYBodyRot;
    private float targetServerYHeadRot;
    private boolean hasTargetRotation = false;
    private int rotationSyncCounter = 0;
    private static final int CLOUD_LEVEL = 195;
    private static final int REGEN_INTERVAL = 50;
    private int regenCounter = 0;
    private static final Logger LOGGER = LogManager.getLogger(HappyGhast.class);
    private long lastLoggedTick = 0L;

    public HappyGhast(EntityType<? extends Ghast> type, Level level) {
        super(type, level);
        this.xpReward = 5;
        this.initComponents();
        if (!this.level().isClientSide()) {
            this.setSpeedMultiplier(GhastMovementComponent.SPEED_MULTIPLIER);
        }
    }

    private void initComponents() {
        if (this.dataComponent == null) {
            this.dataComponent = new GhastDataComponent(this);
        }
        if (this.platformComponent == null) {
            this.platformComponent = new GhastPlatformComponent(this);
        }
        if (this.leashComponent == null) {
            this.leashComponent = new GhastLeashComponent(this);
        }
        if (this.ridingComponent == null) {
            this.ridingComponent = new GhastRidingComponent(this, this.dataComponent, this.platformComponent);
        }
        if (this.movementComponent == null) {
            this.movementComponent = new GhastMovementComponent(this, this.dataComponent, this.platformComponent, this.ridingComponent);
        }
        if (this.interactionComponent == null) {
            this.interactionComponent = new GhastInteractionComponent(this);
        }
        if (this.inventoryComponent == null) {
            this.inventoryComponent = new GhastInventoryComponent(this, this.dataComponent);
        }
    }

    public <T> T getEntityDataValue(EntityDataAccessor<T> key) {
        return (T)this.entityData.get(key);
    }

    public <T> void setEntityDataValue(EntityDataAccessor<T> key, T value) {
        this.entityData.set(key, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SADDLE_ID, (Object)false);
        builder.define(DATA_ASCENDING_ID, (Object)false);
        builder.define(DATA_DESCENDING_ID, (Object)false);
        builder.define(DATA_HARNESS_COLOR, (Object)"blue");
        builder.define(DATA_SPEED_MULTIPLIER, (Object)Float.valueOf(1.0f));
    }

    public boolean isSaddled() {
        return this.getEntityDataValue(DATA_SADDLE_ID);
    }

    public void setSaddled(boolean saddled) {
        this.setEntityDataValue(DATA_SADDLE_ID, saddled);
    }

    public String getHarnessColor() {
        return this.getEntityDataValue(DATA_HARNESS_COLOR);
    }

    public void setHarnessColor(String color) {
        this.setEntityDataValue(DATA_HARNESS_COLOR, color);
    }

    public boolean isAscending() {
        return this.getEntityDataValue(DATA_ASCENDING_ID);
    }

    public void setAscending(boolean ascending) {
        this.setEntityDataValue(DATA_ASCENDING_ID, ascending);
    }

    public boolean isDescending() {
        return this.getEntityDataValue(DATA_DESCENDING_ID);
    }

    public void setDescending(boolean descending) {
        this.setEntityDataValue(DATA_DESCENDING_ID, descending);
    }

    public float getSpeedMultiplier() {
        return this.getEntityDataValue(DATA_SPEED_MULTIPLIER).floatValue();
    }

    public void setSpeedMultiplier(float speedMultiplier) {
        this.setEntityDataValue(DATA_SPEED_MULTIPLIER, Float.valueOf(speedMultiplier));
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public int getMaxPassengers() {
        return 4;
    }

    public void setYRot(float yRot) {
        super.setYRot(yRot);
        if (this.level().isClientSide() || !this.isVehicle() || Math.abs(this.getYRot() - this.lastSyncedYRot) > 2.0f) {
            // empty if block
        }
    }

    public void setXRot(float xRot) {
        super.setXRot(xRot);
        if (this.level().isClientSide() || !this.isVehicle() || Math.abs(this.getXRot() - this.lastSyncedXRot) > 2.0f) {
            // empty if block
        }
    }

    private void syncRotationToClients() {
        if (this.level().isClientSide() || this.rotationSyncCooldown > 0) {
            return;
        }
        this.lastSyncedYRot = this.getYRot();
        this.lastSyncedXRot = this.getXRot();
        try {
            GhastRotationSyncPayload payload = new GhastRotationSyncPayload(this.getId(), this.getYRot(), this.getXRot(), this.yBodyRot, this.yHeadRot);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.rotationSyncCooldown = 2;
        }
        catch (Exception e) {
            LOGGER.error("Error sending rotation sync packet: {}", (Object)e.getMessage());
        }
    }

    public void setTargetServerRotation(float yRot, float xRot, float yBodyRot, float yHeadRot) {
        this.targetServerYRot = yRot;
        this.targetServerXRot = xRot;
        this.targetServerYBodyRot = yBodyRot;
        this.targetServerYHeadRot = yHeadRot;
        this.hasTargetRotation = true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        AnchorManager.setAnchorWithCooldown((Entity)this, this.getX(), this.getY(), this.getZ());
        if (this.isSaddled() && !player.isPassenger() && this.platformComponent != null && this.platformComponent.isActive()) {
            boolean success;
            if (!this.level().isClientSide && (success = player.startRiding((Entity)this))) {
                this.playGogglesDownSound();
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.interactionComponent != null) {
            return this.interactionComponent.handleInteraction(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    public boolean canAddPassenger(Entity passenger) {
        return this.ridingComponent != null && this.ridingComponent.canAddPassenger(passenger);
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (this.ridingComponent != null) {
            this.ridingComponent.handlePassengerRemoval(passenger);
        }
    }

    public LivingEntity getControllingPassenger() {
        return this.ridingComponent != null ? this.ridingComponent.getControllingPassenger() : null;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.ridingComponent != null) {
            this.ridingComponent.positionRider(passenger, moveFunction);
        } else {
            super.positionRider(passenger, moveFunction);
        }
    }

    public void onPassengerTurned(Entity passenger) {
        super.onPassengerTurned(passenger);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return this.ridingComponent != null ? this.ridingComponent.getDismountLocationForPassenger(passenger) : super.getDismountLocationForPassenger(passenger);
    }

    public void travel(Vec3 travelVector) {
        if (this.movementComponent != null) {
            this.movementComponent.handleTravel(travelVector);
            if (this.isVehicle() || !this.isAlive() || this.platformComponent != null && this.platformComponent.isActive() && !this.level().isClientSide()) {
                return;
            }
        }
        super.travel(travelVector);
    }

    public void applyControlledMovement(Vec3 movement) {
        super.travel(movement);
    }

    public void push(Entity entity) {
        if (this.platformComponent == null || !this.platformComponent.shouldDisableCollisionWith(entity)) {
            super.push(entity);
        }
    }

    public void push(double dx, double dy, double dz) {
        if (this.level().isClientSide() || this.platformComponent == null || !this.platformComponent.isActive()) {
            super.push(dx, dy, dz);
        }
    }

    public boolean isPushable() {
        return this.movementComponent != null ? this.movementComponent.isPushable() : super.isPushable();
    }

    public boolean canCollideWith(Entity otherEntity) {
        return (this.movementComponent == null || this.movementComponent.canCollideWith(otherEntity)) && super.canCollideWith(otherEntity);
    }

    private void serverTick() {
        LivingEntity driver;
        Vec3 deceleration;
        if (this.dataComponent == null) {
            this.initComponents();
        }
        if (!AnchorManager.hasAnchor((Entity)this)) {
            AnchorManager.setAnchor((Entity)this, this.getX(), this.getY(), this.getZ());
        }
        if (!AnchorManager.isFollowing((Entity)this) && !this.isVehicle() && (deceleration = AnchorManager.getDecelerationVector((Entity)this)).lengthSqr() > 1.0E-4) {
            this.setDeltaMovement(deceleration);
        }
        if (this.inventoryComponent == null && this.dataComponent != null) {
            this.inventoryComponent = new GhastInventoryComponent(this, this.dataComponent);
        }
        if (this.platformComponent != null) {
            this.platformComponent.tick();
        }
        if (this.isLeashed() && this.leashComponent != null) {
            this.leashComponent.tickLeash();
        }
        if (this.isVehicle() && (driver = this.getControllingPassenger()) != null) {
            float targetYRot = driver.getYRot();
            float targetXRot = driver.getXRot() * 0.5f;
            float yRotDiff = targetYRot - this.getYRot();
            if (yRotDiff > 180.0f) {
                yRotDiff -= 360.0f;
            }
            if (yRotDiff < -180.0f) {
                yRotDiff += 360.0f;
            }
            float serverSmoothFactor = 0.6f;
            this.setYRot(this.getYRot() + yRotDiff * serverSmoothFactor);
            this.setXRot(targetXRot);
            this.yHeadRot = this.yBodyRot = this.getYRot();
            ++this.rotationSyncCounter;
            if (this.rotationSyncCounter >= 2 || Math.abs(this.getYRot() - this.lastSyncedYRot) > 2.0f || Math.abs(this.getXRot() - this.lastSyncedXRot) > 2.0f) {
                this.syncRotationToClients();
                this.rotationSyncCounter = 0;
            } else if (this.rotationSyncCooldown > 0) {
                --this.rotationSyncCooldown;
            }
        }
        this.handleHealthRegeneration();
    }

    private void clientTick() {
        if (this.hasTargetRotation) {
            boolean isDriver;
            Minecraft minecraft = Minecraft.getInstance();
            boolean bl = isDriver = minecraft.player != null && this.getPassengers().contains(minecraft.player) && this.getPassengers().indexOf(minecraft.player) == 0;
            if (!isDriver) {
                float maxRotationStep = 6.0f;
                float yRotDiff = Mth.wrapDegrees((float)(this.targetServerYRot - this.getYRot()));
                float speedFactor = Math.min(1.0f, Math.abs(yRotDiff) / 45.0f + 0.3f);
                float yRotStep = Mth.clamp((float)(yRotDiff * speedFactor), (float)(-maxRotationStep), (float)maxRotationStep);
                this.setYRot(Mth.wrapDegrees((float)(this.getYRot() + yRotStep)));
                float xRotDiff = this.targetServerXRot - this.getXRot();
                float xRotStep = Mth.clamp((float)(xRotDiff * speedFactor), (float)(-maxRotationStep), (float)maxRotationStep);
                this.setXRot(this.getXRot() + xRotStep);
                float bodyRotDiff = Mth.wrapDegrees((float)(this.targetServerYBodyRot - this.yBodyRot));
                float bodyRotStep = Mth.clamp((float)(bodyRotDiff * speedFactor), (float)(-maxRotationStep), (float)maxRotationStep);
                this.yHeadRot = this.yBodyRot = Mth.wrapDegrees((float)(this.yBodyRot + bodyRotStep));
                if (Math.abs(yRotDiff) < 0.5f && Math.abs(xRotDiff) < 0.5f) {
                    this.hasTargetRotation = false;
                }
            } else {
                this.hasTargetRotation = false;
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public GhastInventoryComponent getInventoryComponent() {
        if (this.inventoryComponent == null) {
            this.initComponents();
        }
        return this.inventoryComponent;
    }

    public GhastLeashComponent getLeashComponent() {
        return this.leashComponent;
    }

    public GhastPlatformComponent getPlatformComponent() {
        return this.platformComponent;
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide()) {
            AnchorManager.removeAnchor((Entity)this);
            if (this.platformComponent != null) {
                this.platformComponent.onOwnerRemoved();
            }
            if (this.isLeashed()) {
                this.dropLeash(true, false);
            }
        }
        super.remove(reason);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new HappyGhastFollowPlayerWithItemGoal(this, 1.0, 30.0f));
        this.goalSelector.addGoal(5, (Goal)new HappyGhastRandomFloatGoal(this));
        this.goalSelector.addGoal(7, (Goal)new HappyGhastLookGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Ghast.createAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsSaddled", this.isSaddled());
        if (this.isSaddled()) {
            compound.putString("HarnessColor", this.getHarnessColor());
        }
        compound.putFloat("SpeedMultiplier", this.getSpeedMultiplier());
        if (this.dataComponent != null) {
            this.dataComponent.addAdditionalSaveData(compound);
        }
        if (this.platformComponent != null) {
            this.platformComponent.addAdditionalSaveData(compound);
        }
        if (this.inventoryComponent != null && this.level() != null) {
            RegistryAccess provider = this.level().registryAccess();
            this.inventoryComponent.addAdditionalSaveData(compound, (HolderLookup.Provider)provider);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.dataComponent == null) {
            this.initComponents();
        }
        this.setSaddled(compound.getBoolean("IsSaddled"));
        if (compound.contains("HarnessColor")) {
            this.setHarnessColor(compound.getString("HarnessColor"));
        } else if (this.isSaddled()) {
            this.setHarnessColor("blue");
        }
        if (compound.contains("SpeedMultiplier")) {
            this.setSpeedMultiplier(compound.getFloat("SpeedMultiplier"));
        } else {
            this.setSpeedMultiplier(GhastMovementComponent.SPEED_MULTIPLIER);
        }
        if (this.dataComponent != null) {
            this.dataComponent.readAdditionalSaveData(compound);
        }
        if (this.platformComponent != null) {
            this.platformComponent.readAdditionalSaveData(compound);
        }
        if (this.inventoryComponent != null && this.level() != null) {
            RegistryAccess provider = this.level().registryAccess();
            this.inventoryComponent.readAdditionalSaveData(compound, (HolderLookup.Provider)provider);
        }
        if (this.inventoryComponent != null) {
            this.inventoryComponent.syncInventoryWithState();
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void setCharging(boolean charging) {
        super.setCharging(false);
    }

    public void setLeashedTo(Entity entity, boolean sendPacket) {
        super.setLeashedTo(entity, sendPacket);
        if (this.leashComponent != null) {
            this.leashComponent.onLeashDropped(false, false);
        }
    }

    public void dropLeash(boolean broadcast, boolean dropItem) {
        super.dropLeash(broadcast, dropItem);
        if (this.leashComponent != null) {
            this.leashComponent.onLeashDropped(broadcast, dropItem);
        }
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public void refreshSaddle() {
        if (this.level().isClientSide()) {
            boolean currentSaddled = this.isSaddled();
            String currentColor = this.getHarnessColor();
            this.setSaddled(currentSaddled);
            this.setHarnessColor(currentColor);
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundInit.HAPPY_GHAST_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundInit.HAPPY_GHAST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundInit.HAPPY_GHAST_DEATH.get();
    }

    public void playRideSound() {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundInit.HAPPY_GHAST_RIDE.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void playGogglesDownSound() {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundInit.HAPPY_GHAST_GOGGLES_DOWN.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void playGogglesUpSound() {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundInit.HAPPY_GHAST_GOGGLES_UP.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void playHarnessEquipSound() {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundInit.HAPPY_GHAST_HARNESS_EQUIP.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void playHarnessUnequipSound() {
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundInit.HAPPY_GHAST_HARNESS_UNEQUIP.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    private void handleHealthRegeneration() {
        if (this.level().isClientSide() || this.getHealth() >= this.getMaxHealth()) {
            this.regenCounter = 0;
            return;
        }
        boolean isAtCloudLevel = this.getY() >= 195.0;
        boolean isRainingOrSnowing = this.level().isRaining();
        if (isAtCloudLevel || isRainingOrSnowing) {
            ++this.regenCounter;
            if (this.regenCounter >= 50) {
                this.heal(1.0f);
                this.regenCounter = 0;
                if (this.tickCount % 10 == 0) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                }
            }
        }
    }

    public GhastDataComponent getDataComponent() {
        if (this.dataComponent == null) {
            this.initComponents();
        }
        return this.dataComponent;
    }
}

