/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.AnchorManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.goals.GhastlingFollowPlayerWithSnowballGoal;
import dev.nweaver.happyghastmod.entity.goals.GhastlingLookGoal;
import dev.nweaver.happyghastmod.entity.goals.GhastlingRandomFloatGoal;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Ghastling
extends Ghast {
    private static final int TRANSFORM_TIME = 24000;
    private static final int FEED_TRANSFORM_BOOST = 1200;
    private static final int PARTICLE_COUNT = 5;
    private static final double GHASTLING_MAX_LEASH_DISTANCE = 5.0;
    private static final double GHASTLING_MAX_LEASH_DISTANCE_SQR = 25.0;
    private static final double GHASTLING_COMFORT_ZONE_RATIO = 0.8;
    private static final double GHASTLING_COMFORT_ZONE_SQR = 20.0;
    private static final double GHASTLING_LEASH_PULL_STRENGTH = 0.06;
    private static final double GHASTLING_LEASH_VERTICAL_PULL_STRENGTH = 0.04;
    private static final double GHASTLING_MOTION_DAMPING = 0.92;
    private static final double GHASTLING_VERTICAL_DAMPING = 0.95;
    private static final double GHASTLING_PULL_FORCE_SMOOTHING = 0.2;
    private Vec3 smoothedPullForce = Vec3.ZERO;
    private static final double MAX_LEASHED_SPEED = 0.45;
    public static final int MIN_HEIGHT_ABOVE_GROUND = 1;
    public static final int MAX_HEIGHT_ABOVE_GROUND = 2;
    private boolean anchorInitialized = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Integer> DATA_TRANSFORM_PROGRESS = SynchedEntityData.defineId(Ghastling.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Ghastling(EntityType<? extends Ghast> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 1;
    }

    public int getTransformProgress() {
        return (Integer)this.entityData.get(DATA_TRANSFORM_PROGRESS);
    }

    public void setTransformProgress(int progress) {
        this.entityData.set(DATA_TRANSFORM_PROGRESS, (Object)progress);
    }

    public int getGroundHeight() {
        int entityX = Mth.floor((double)this.getX());
        int entityZ = Mth.floor((double)this.getZ());
        int startY = Mth.floor((double)this.getY()) - 1;
        int minY = Math.max(0, startY - 20);
        for (int y = startY; y >= minY; --y) {
            VoxelShape collisionShape;
            BlockPos blockPos = new BlockPos(entityX, y, entityZ);
            BlockState blockState = this.level().getBlockState(blockPos);
            if (blockState.isAir() || blockState.liquid() || (collisionShape = blockState.getCollisionShape((BlockGetter)this.level(), blockPos)).isEmpty()) continue;
            return y + 1;
        }
        return -1;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            int currentProgress;
            if (!this.anchorInitialized) {
                AnchorManager.setAnchor((Entity)this, this.getX(), this.getY(), this.getZ());
                this.anchorInitialized = true;
                LOGGER.debug("Initialized anchor for Ghastling at spawn location: {}, {}, {}", (Object)this.getX(), (Object)this.getY(), (Object)this.getZ());
            }
            if ((currentProgress = this.getTransformProgress()) >= 24000) {
                this.transformToHappyGhast();
                return;
            }
            this.setTransformProgress(currentProgress + 1);
            int groundY = this.getGroundHeight();
            if (groundY != -1) {
                double maxAllowedY = groundY + 2;
                if (this.getY() > maxAllowedY) {
                    Vec3 motion = this.getDeltaMovement();
                    double gravityFactor = Math.min(0.08, (this.getY() - maxAllowedY) * 0.02);
                    this.setDeltaMovement(motion.x, Math.max(motion.y - gravityFactor, -0.2), motion.z);
                }
            }
            if (AnchorManager.hasAnchor((Entity)this)) {
                double dz;
                Vec3 anchor = AnchorManager.getAnchor((Entity)this);
                double maxRadius = AnchorManager.getMaxRadius((Entity)this);
                double dx = this.getX() - anchor.x;
                double distSquared = dx * dx + (dz = this.getZ() - anchor.z) * dz;
                if (distSquared > maxRadius * maxRadius) {
                    double dist = Math.sqrt(distSquared);
                    double scale = maxRadius / dist;
                    double newX = anchor.x + dx * scale;
                    double newZ = anchor.z + dz * scale;
                    Vec3 motion = this.getDeltaMovement();
                    double pullStrength = 0.05;
                    double moveX = (newX - this.getX()) * pullStrength;
                    double moveZ = (newZ - this.getZ()) * pullStrength;
                    this.setDeltaMovement(motion.x + moveX, motion.y, motion.z + moveZ);
                    this.hasImpulse = true;
                }
            }
            if (this.isLeashed()) {
                Entity leashHolder = this.getLeashHolder();
                if (leashHolder != null && leashHolder.level() == this.level()) {
                    double distanceSqr = this.distanceToSqr(leashHolder);
                    Vec3 currentDelta = this.getDeltaMovement();
                    Vec3 dampedDelta = currentDelta.multiply(0.92, 0.95, 0.92);
                    if (distanceSqr > 20.0) {
                        Vec3 newDelta;
                        Vec3 currentPos = this.position();
                        Vec3 holderPos = leashHolder.position();
                        Vec3 vecToHolder = holderPos.subtract(currentPos);
                        double currentDist = Math.sqrt(distanceSqr);
                        double maxDist = Math.sqrt(25.0);
                        double comfortDist = Math.sqrt(20.0);
                        double overshootRatio = Math.min(1.0, (currentDist - comfortDist) / (maxDist - comfortDist));
                        double pullStrengthFactor = overshootRatio * 0.06;
                        Vec3 rawPullForce = vecToHolder.normalize().scale(pullStrengthFactor);
                        this.smoothedPullForce = this.smoothedPullForce.scale(0.8).add(rawPullForce.scale(0.2));
                        double verticalDiff = holderPos.y - currentPos.y;
                        Vec3 extraVerticalForce = Vec3.ZERO;
                        if (Math.abs(verticalDiff) > 1.0) {
                            double verticalRatio = Math.min(Math.abs(verticalDiff) / 10.0, 1.0);
                            double yPullStrength = verticalRatio * verticalRatio * 0.04;
                            extraVerticalForce = new Vec3(0.0, Math.signum(verticalDiff) * yPullStrength, 0.0);
                        }
                        if ((newDelta = dampedDelta.add(this.smoothedPullForce).add(extraVerticalForce)).lengthSqr() > 0.2025) {
                            newDelta = newDelta.normalize().scale(0.45);
                        }
                        this.setDeltaMovement(newDelta);
                        this.hasImpulse = true;
                    } else {
                        this.setDeltaMovement(dampedDelta);
                        this.smoothedPullForce = this.smoothedPullForce.lengthSqr() > 1.0E-6 ? this.smoothedPullForce.scale(0.8) : Vec3.ZERO;
                    }
                } else {
                    this.smoothedPullForce = Vec3.ZERO;
                    if (leashHolder == null || leashHolder.isRemoved()) {
                        this.dropLeash(true, true);
                    }
                }
            } else {
                this.smoothedPullForce = Vec3.ZERO;
            }
            this.handleWaterAvoidance();
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Level level = this.level();
        if (itemstack.is(Items.SNOWBALL)) {
            if (!level.isClientSide()) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
                this.heal(1.5f);
                int currentProgress = this.getTransformProgress();
                this.setTransformProgress(Math.min(currentProgress + 1200, 24000));
                this.spawnGreenParticles();
                if (this.getTransformProgress() >= 24000) {
                    this.transformToHappyGhast();
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (itemstack.is(Items.LEAD)) {
            if (!level.isClientSide() && this.canBeLeashed(player)) {
                this.setLeashedTo((Entity)player, true);
                this.gameEvent((Holder)GameEvent.ENTITY_INTERACT, (Entity)player);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                level.playSound(null, (Entity)this, SoundEvents.LEASH_KNOT_PLACE, SoundSource.NEUTRAL, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public boolean canBeLeashed(Player player) {
        return !this.isLeashed();
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(this.getBbHeight() * 0.5f), 0.0);
    }

    private void spawnGreenParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d0 = this.getBoundingBox().getCenter().x;
            double d1 = this.getBoundingBox().getCenter().y;
            double d2 = this.getBoundingBox().getCenter().z;
            for (int i = 0; i < 5; ++i) {
                double offsetX = this.random.nextGaussian() * 0.8;
                double offsetY = this.random.nextGaussian() * 0.8;
                double offsetZ = this.random.nextGaussian() * 0.8;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, d0 + offsetX, d1 + offsetY, d2 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void transformToHappyGhast() {
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        HappyGhast happyGhast = (HappyGhast)((EntityType)EntityInit.HAPPY_GHAST.get()).create(this.level());
        if (happyGhast != null) {
            if (this.isLeashed()) {
                this.dropLeash(true, true);
            }
            happyGhast.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            if (this.hasCustomName()) {
                happyGhast.setCustomName(this.getCustomName());
            }
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.HOSTILE, 1.0f, 1.0f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 30; ++i) {
                    double offsetX = this.random.nextGaussian() * 1.2;
                    double offsetY = this.random.nextGaussian() * 1.2;
                    double offsetZ = this.random.nextGaussian() * 1.2;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            this.level().addFreshEntity((Entity)happyGhast);
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag c) {
        super.addAdditionalSaveData(c);
        c.putInt("TransformProgress", this.getTransformProgress());
        c.putBoolean("AnchorInitialized", this.anchorInitialized);
    }

    public void readAdditionalSaveData(CompoundTag c) {
        super.readAdditionalSaveData(c);
        if (c.contains("TransformProgress")) {
            this.setTransformProgress(c.getInt("TransformProgress"));
        }
        this.anchorInitialized = c.getBoolean("AnchorInitialized");
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GhastlingFollowPlayerWithSnowballGoal(this, 1.0, 30.0f));
        this.goalSelector.addGoal(5, (Goal)new GhastlingRandomFloatGoal(this));
        this.goalSelector.addGoal(7, (Goal)new GhastlingLookGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void setCharging(boolean charging) {
        super.setCharging(false);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.level().isClientSide() || !this.isLeashed() || reason != Entity.RemovalReason.DISCARDED) {
            // empty if block
        }
        super.remove(reason);
    }

    public void dropLeash(boolean broadcastPacket, boolean dropLeashItem) {
        this.smoothedPullForce = Vec3.ZERO;
        super.dropLeash(broadcastPacket, dropLeashItem);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundInit.GHASTLING_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundInit.GHASTLING_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundInit.GHASTLING_DEATH.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    private void handleWaterAvoidance() {
        double distanceToWater;
        if (this.level().isClientSide()) {
            return;
        }
        int entityX = Mth.floor((double)this.getX());
        int entityZ = Mth.floor((double)this.getZ());
        int entityY = Mth.floor((double)(this.getY() - 0.2));
        boolean waterBelow = false;
        int waterSurfaceY = -1;
        for (int y = entityY; y > entityY - 5 && y > 0; --y) {
            BlockPos blockPos = new BlockPos(entityX, y, entityZ);
            FluidState fluidState = this.level().getFluidState(blockPos);
            if (!fluidState.isEmpty() && fluidState.is(FluidTags.WATER)) {
                waterBelow = true;
                waterSurfaceY = y + 1;
                break;
            }
            if (!this.level().getBlockState(blockPos).isAir()) break;
        }
        BlockPos currentPos = this.blockPosition();
        boolean inWater = this.level().getFluidState(currentPos).is(FluidTags.WATER);
        if (inWater) {
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, Math.max(0.1, motion.y + 0.08), motion.z);
            this.hasImpulse = true;
        } else if (waterBelow && waterSurfaceY != -1 && (distanceToWater = this.getY() - (double)waterSurfaceY) < 2.0) {
            double repulsionForce = Math.max(0.02, 0.05 * (2.0 - distanceToWater));
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x, Math.max(0.0, motion.y + repulsionForce), motion.z);
            this.hasImpulse = true;
        }
    }

    public void travel(Vec3 travelVector) {
        if (this.isInWater()) {
            travelVector = new Vec3(travelVector.x, Math.max(0.05, travelVector.y + 0.05), travelVector.z);
        }
        super.travel(travelVector);
        if (this.isInWater()) {
            this.move(MoverType.SELF, new Vec3(0.0, 0.05, 0.0));
        }
    }

    public boolean isPositionSafeForMovement(double x, double y, double z) {
        BlockPos targetPos = new BlockPos(Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z));
        return !this.level().getFluidState(targetPos).is(FluidTags.WATER);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TRANSFORM_PROGRESS, (Object)0);
    }
}

