/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.EntityInit;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GhastPlatformEntity
extends Entity {
    public static final EntityDimensions FIXED_DIMENSIONS = EntityDimensions.scalable((float)4.0f, (float)0.5f);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(GhastPlatformEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public GhastPlatformEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public GhastPlatformEntity(Level level, double x, double y, double z, HappyGhast owner) {
        this((EntityType)EntityInit.GHAST_PLATFORM.get(), level);
        this.setPos(x, y, z);
        this.setOwnerUUID(owner.getUUID());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty());
    }

    public void push(Entity pEntity) {
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.getOwnerUUID().isPresent()) {
            Entity owner = null;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                owner = serverLevel.getEntity(this.getOwnerUUID().get());
            }
            if (owner == null || !owner.isAlive()) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(Vec3.ZERO);
        if (this.tickCount > 1) {
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.entityData.get(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public HappyGhast getOwner() {
        try {
            ServerLevel serverLevel;
            Entity entity;
            Level level;
            UUID uuid = this.getOwnerUUID().orElse(null);
            if (uuid != null && (level = this.level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).getEntity(uuid)) instanceof HappyGhast) {
                HappyGhast happyGhast = (HappyGhast)entity;
                return happyGhast;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return !this.isRemoved();
    }

    protected void doWaterSplashEffect() {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        AABB aabb = this.getType().getDimensions().makeBoundingBox(x, y, z);
        this.setBoundingBox(aabb);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("Owner")) {
            this.setOwnerUUID(compound.getUUID("Owner"));
        } else {
            this.setOwnerUUID(null);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        this.getOwnerUUID().ifPresent(uuid -> compound.putUUID("Owner", uuid));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return super.getAddEntityPacket(serverEntity);
    }
}

