/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.entity;

import dev.nweaver.happyghastmod.entity.Ghastling;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnchorManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<UUID, Vec3> anchors = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Long> followingTimestamps = new HashMap<UUID, Long>();
    private static final Map<UUID, Vec3> lastPlayerPositions = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> movementVectors = new HashMap<UUID, Vec3>();
    private static final long FOLLOWING_TIMEOUT = 5000L;
    private static final double MAX_HEIGHT_OFFSET = 32.0;
    private static final double MIN_HEIGHT_OFFSET = -64.0;
    private static final Map<UUID, Long> lastAnchorUpdateTime = new HashMap<UUID, Long>();
    private static final long ANCHOR_UPDATE_COOLDOWN = 3000L;

    public static void setAnchor(Entity entity, double x, double y, double z) {
        anchors.put(entity.getUUID(), new Vec3(x, y, z));
        LOGGER.debug("Set anchor for entity {} at {}, {}, {}", (Object)entity.getUUID(), (Object)x, (Object)y, (Object)z);
    }

    public static boolean setAnchorWithCooldown(Entity entity, double x, double y, double z) {
        UUID entityId = entity.getUUID();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastAnchorUpdateTime.get(entityId);
        if (lastUpdate != null && currentTime - lastUpdate < 3000L) {
            return false;
        }
        AnchorManager.setAnchor(entity, x, y, z);
        lastAnchorUpdateTime.put(entityId, currentTime);
        return true;
    }

    public static boolean canUpdateAnchor(Entity entity) {
        UUID entityId = entity.getUUID();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastAnchorUpdateTime.get(entityId);
        return lastUpdate == null || currentTime - lastUpdate >= 3000L;
    }

    public static boolean hasAnchor(Entity entity) {
        return anchors.containsKey(entity.getUUID());
    }

    public static Vec3 getAnchor(Entity entity) {
        return anchors.get(entity.getUUID());
    }

    public static void removeAnchor(Entity entity) {
        anchors.remove(entity.getUUID());
    }

    public static void markAsFollowing(Entity entity) {
        followingTimestamps.put(entity.getUUID(), System.currentTimeMillis());
    }

    public static void stopFollowing(Entity entity) {
        followingTimestamps.remove(entity.getUUID());
        if (entity.getDeltaMovement().lengthSqr() > 0.01) {
            movementVectors.put(entity.getUUID(), entity.getDeltaMovement());
        }
    }

    public static boolean isFollowing(Entity entity) {
        Long timestamp = followingTimestamps.get(entity.getUUID());
        if (timestamp == null) {
            return false;
        }
        return System.currentTimeMillis() - timestamp < 5000L;
    }

    public static void updateLastPlayerPosition(Entity entity, double x, double y, double z) {
        lastPlayerPositions.put(entity.getUUID(), new Vec3(x, y, z));
    }

    public static Vec3 getLastPlayerPosition(Entity entity) {
        return lastPlayerPositions.get(entity.getUUID());
    }

    public static double getMaxRadius(Entity entity) {
        if (AnchorManager.isFollowing(entity)) {
            return 64.0;
        }
        if (entity instanceof Ghastling) {
            return 32.0;
        }
        if (entity instanceof HappyGhast) {
            HappyGhast happyGhast = (HappyGhast)entity;
            return happyGhast.isSaddled() ? 32.0 : 64.0;
        }
        return 64.0;
    }

    public static double getMaxHeightOffset() {
        return 32.0;
    }

    public static double getMinHeightOffset() {
        return -64.0;
    }

    public static double constrainHeight(Entity entity, double y) {
        Ghastling ghastling;
        int groundY;
        if (!AnchorManager.hasAnchor(entity)) {
            return y;
        }
        if (entity instanceof Ghastling && (groundY = (ghastling = (Ghastling)entity).getGroundHeight()) != -1) {
            double maxY = groundY + 4;
            double minY = groundY + 2;
            double minHeightAboveGround = Math.max(minY, (double)(entity.level().getSeaLevel() + 2));
            return Math.max(minHeightAboveGround, Math.min(y, maxY));
        }
        if (AnchorManager.isFollowing(entity)) {
            Vec3 lastPlayerPos = AnchorManager.getLastPlayerPosition(entity);
            if (lastPlayerPos != null && entity.getY() > lastPlayerPos.y + 10.0) {
                double minHeightAboveGround = Math.max((double)(entity.level().getSeaLevel() + 2), lastPlayerPos.y - 2.0);
                return Math.max(minHeightAboveGround, y);
            }
            double minHeightAboveGround = entity.level().getSeaLevel() + 5;
            return Math.max(minHeightAboveGround, y);
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double maxY = anchor.y + 32.0;
        double minY = anchor.y + -64.0;
        double minHeightAboveGround = entity.level().getSeaLevel() + 5;
        minY = Math.max(minY, minHeightAboveGround);
        return Math.max(minY, Math.min(y, maxY));
    }

    public static boolean isWithinAllowedRadius(Entity entity, double x, double y, double z) {
        if (AnchorManager.isFollowing(entity)) {
            return true;
        }
        if (!AnchorManager.hasAnchor(entity)) {
            return true;
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double maxRadius = AnchorManager.getMaxRadius(entity);
        double dx = x - anchor.x;
        double dz = z - anchor.z;
        double horizontalDistSq = dx * dx + dz * dz;
        double dy = y - anchor.y;
        boolean withinHorizontalRadius = horizontalDistSq <= maxRadius * maxRadius;
        boolean withinVerticalRange = dy >= -64.0 && dy <= 32.0;
        return withinHorizontalRadius && withinVerticalRange;
    }

    public static boolean createTemporaryAnchor(Entity entity, double playerX, double playerY, double playerZ) {
        if (!AnchorManager.canUpdateAnchor(entity)) {
            return false;
        }
        if (!AnchorManager.hasAnchor(entity)) {
            return AnchorManager.setAnchorWithCooldown(entity, entity.getX(), entity.getY(), entity.getZ());
        }
        Vec3 anchor = AnchorManager.getAnchor(entity);
        double dx = playerX - anchor.x;
        double dz = playerZ - anchor.z;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist < AnchorManager.getMaxRadius(entity) * 0.7) {
            return false;
        }
        double scale = 0.3;
        double newX = anchor.x + dx * scale;
        double newY = playerY;
        double newZ = anchor.z + dz * scale;
        boolean updated = AnchorManager.setAnchorWithCooldown(entity, newX, newY, newZ);
        if (updated) {
            LOGGER.debug("Created temporary anchor at {}, {}, {}", (Object)newX, (Object)newY, (Object)newZ);
        }
        return updated;
    }

    public static Vec3 getDecelerationVector(Entity entity) {
        Vec3 vector = movementVectors.get(entity.getUUID());
        if (vector == null) {
            return Vec3.ZERO;
        }
        double deceleration = 0.8;
        Vec3 newVector = vector.scale(deceleration);
        if (newVector.lengthSqr() < 0.001) {
            movementVectors.remove(entity.getUUID());
            return Vec3.ZERO;
        }
        movementVectors.put(entity.getUUID(), newVector);
        return newVector;
    }
}

