/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.datagen;

import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.core.registration.ModConfiguredFeatures;
import dev.nweaver.happyghastmod.core.registration.ModFeatures;
import dev.nweaver.happyghastmod.core.registration.ModPlacedFeatures;
import dev.nweaver.happyghastmod.worldgen.biome.AddIncubatorModifier;
import dev.nweaver.happyghastmod.worldgen.feature.GhastlingIncubatorFeature;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModWorldGenProvider
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModWorldGenProvider::bootstrapConfiguredFeatures).add(Registries.PLACED_FEATURE, ModWorldGenProvider::bootstrapPlacedFeatures).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ModWorldGenProvider::bootstrapBiomeModifiers);

    public ModWorldGenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("happyghastmod"));
    }

    private static void bootstrapConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        context.register(ModConfiguredFeatures.GHASTLING_INCUBATOR_CONFIGURED, (Object)new ConfiguredFeature((Feature)((GhastlingIncubatorFeature)((Object)ModFeatures.GHASTLING_INCUBATOR_FEATURE.get())), (FeatureConfiguration)NoneFeatureConfiguration.INSTANCE));
    }

    private static void bootstrapPlacedFeatures(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureRegistry = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference incubatorConfiguredHolder = configuredFeatureRegistry.getOrThrow(ModConfiguredFeatures.GHASTLING_INCUBATOR_CONFIGURED);
        context.register(ModPlacedFeatures.GHASTLING_INCUBATOR_PLACED, (Object)new PlacedFeature((Holder)incubatorConfiguredHolder, List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)10), (VerticalAnchor)VerticalAnchor.absolute((int)120)), BiomeFilter.biome())));
    }

    private static void bootstrapBiomeModifiers(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatureRegistry = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        Holder.Reference incubatorPlacedHolder = placedFeatureRegistry.getOrThrow(ModPlacedFeatures.GHASTLING_INCUBATOR_PLACED);
        ResourceKey addIncubatorModifierKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)HappyGhastMod.rl("add_ghastling_incubator"));
        context.register(addIncubatorModifierKey, (Object)new AddIncubatorModifier((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeRegistry.getOrThrow(Biomes.SOUL_SAND_VALLEY), biomeRegistry.getOrThrow(Biomes.CRIMSON_FOREST), biomeRegistry.getOrThrow(Biomes.WARPED_FOREST), biomeRegistry.getOrThrow(Biomes.BASALT_DELTAS), biomeRegistry.getOrThrow(Biomes.NETHER_WASTES)}), (Holder<PlacedFeature>)incubatorPlacedHolder));
    }

    public String getName() {
        return "World Gen Provider: happyghastmod";
    }
}

