/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.data;

import dev.nweaver.happyghastmod.init.ItemInit;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="happyghastmod", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new HarnessRecipes(packOutput, lookupProvider));
    }

    private static class HarnessRecipes
    extends RecipeProvider {
        public HarnessRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            this.createStandardHarnessRecipe(recipeOutput, "black", Items.BLACK_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "blue", Items.BLUE_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "brown", Items.BROWN_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "cyan", Items.CYAN_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "gray", Items.GRAY_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "green", Items.GREEN_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "light_blue", Items.LIGHT_BLUE_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "light_gray", Items.LIGHT_GRAY_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "lime", Items.LIME_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "magenta", Items.MAGENTA_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "orange", Items.ORANGE_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "red", Items.RED_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "white", Items.WHITE_WOOL);
            this.createStandardHarnessRecipe(recipeOutput, "yellow", Items.YELLOW_WOOL);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemInit.HARNESS_ITEMS.get("moddy").get())).pattern("LLL").pattern("GWG").pattern("JJJ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('W'), (ItemLike)Items.GRAY_WOOL).define(Character.valueOf('J'), (ItemLike)Items.BLACK_WOOL).group("harness").unlockedBy("has_leather", HarnessRecipes.has((ItemLike)Items.LEATHER)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemInit.HARNESS_ITEMS.get("pwgood").get())).pattern("LWL").pattern("WJW").pattern("   ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('W'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('J'), (ItemLike)Items.YELLOW_WOOL).group("harness").unlockedBy("has_leather", HarnessRecipes.has((ItemLike)Items.LEATHER)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemInit.HARNESS_ITEMS.get("pwgoods").get())).pattern("LLL").pattern("WJW").pattern("   ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('W'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('J'), (ItemLike)Items.YELLOW_WOOL).group("harness").unlockedBy("has_leather", HarnessRecipes.has((ItemLike)Items.LEATHER)).save(recipeOutput);
            if (ItemInit.HARNESS_ITEMS.containsKey("purple")) {
                this.createStandardHarnessRecipe(recipeOutput, "purple", Items.PURPLE_WOOL);
            }
            if (ItemInit.HARNESS_ITEMS.containsKey("pink")) {
                this.createStandardHarnessRecipe(recipeOutput, "pink", Items.PINK_WOOL);
            }
        }

        private void createStandardHarnessRecipe(RecipeOutput recipeOutput, String color, Item wool) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemInit.HARNESS_ITEMS.get(color).get())).pattern("LLL").pattern("GWG").pattern("   ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('W'), (ItemLike)wool).group("harness").unlockedBy("has_leather", HarnessRecipes.has((ItemLike)Items.LEATHER)).save(recipeOutput);
        }
    }
}

