/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.nweaver.happyghastmod.item.HarnessItem;
import dev.nweaver.happyghastmod.network.SyncCustomHarnessPayload;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="happyghastmod")
public class CustomHarnessManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CUSTOM_HARNESSES_DIR = "happyghastmod/custom_harnesses";
    private static final String REGISTRY_FILE = "registry.json";
    private static final Map<String, CustomHarnessData> registeredHarnesses = new HashMap<String, CustomHarnessData>();

    public static boolean isSinglePlayerServer(MinecraftServer server) {
        return server != null && server.isSingleplayer();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        if (CustomHarnessManager.isSinglePlayerServer(event.getServer())) {
            CustomHarnessManager.loadRegistry();
        } else {
            LOGGER.info("Custom harnesses are currently disabled in multiplayer. They will be loaded in single-player only.");
            registeredHarnesses.clear();
        }
    }

    public static boolean registerCustomHarness(String harnessId, String harnessName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData, ServerPlayer player) {
        if (!CustomHarnessManager.isSinglePlayerServer(player.getServer())) {
            LOGGER.info("Custom harnesses are currently disabled in multiplayer. Player {} attempted to create a harness.", (Object)player.getName().getString());
            return false;
        }
        if (player == null) {
            LOGGER.error("Cannot register custom harness: player is null.");
            return false;
        }
        try {
            Path baseDir = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR);
            Path harnessDir = baseDir.resolve(harnessId);
            Files.createDirectories(harnessDir, new FileAttribute[0]);
            boolean hasSaddleTexture = false;
            boolean hasGlassesTexture = false;
            boolean hasAccessoryTexture = false;
            if (saddleTextureData != null && saddleTextureData.length > 0) {
                Files.write(harnessDir.resolve("saddle.png"), saddleTextureData, new OpenOption[0]);
                hasSaddleTexture = true;
            }
            if (glassesTextureData != null && glassesTextureData.length > 0) {
                Files.write(harnessDir.resolve("glasses.png"), glassesTextureData, new OpenOption[0]);
                hasGlassesTexture = true;
            }
            if (accessoryTextureData != null && accessoryTextureData.length > 0) {
                Files.write(harnessDir.resolve("accessory.png"), accessoryTextureData, new OpenOption[0]);
                hasAccessoryTexture = true;
            }
            CustomHarnessData data = new CustomHarnessData(harnessId, harnessName, player.getStringUUID(), player.getName().getString(), hasSaddleTexture, hasGlassesTexture, hasAccessoryTexture);
            registeredHarnesses.put(harnessId, data);
            CustomHarnessManager.saveRegistry();
            CustomHarnessManager.syncCustomHarnessToAllPlayers(data, saddleTextureData, glassesTextureData, accessoryTextureData);
            LOGGER.info("\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0430\u044f \u0441\u0431\u0440\u0443\u044f: ID={}, Name={}", (Object)harnessId, (Object)harnessName);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0443\u044e \u0441\u0431\u0440\u0443\u044e ID {}: {}", (Object)harnessId, (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0439 \u0441\u0431\u0440\u0443\u0438 ID {}: {}", (Object)harnessId, (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static void syncAllHarnessesToPlayer(ServerPlayer player) {
        if (!CustomHarnessManager.isSinglePlayerServer(player.getServer()) || player == null) {
            LOGGER.debug("Skipping custom harness sync for player {} (not singleplayer or player is null)", (Object)(player != null ? player.getName().getString() : "null"));
            return;
        }
        LOGGER.debug("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f {} \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c {}", (Object)registeredHarnesses.size(), (Object)player.getName().getString());
        for (Map.Entry<String, CustomHarnessData> entry : registeredHarnesses.entrySet()) {
            String harnessId = entry.getKey();
            CustomHarnessData data = entry.getValue();
            byte[] saddleTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "saddle");
            byte[] glassesTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "glasses");
            byte[] accessoryTextureData = CustomHarnessManager.loadCustomHarnessTexture(harnessId, "accessory");
            SyncCustomHarnessPayload payload = new SyncCustomHarnessPayload(data.getId(), data.getName(), data.getCreatorName(), saddleTextureData, glassesTextureData, accessoryTextureData);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            LOGGER.trace("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043f\u0430\u043a\u0435\u0442 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0441\u0431\u0440\u0443\u0438 {} \u0438\u0433\u0440\u043e\u043a\u0443 {}", (Object)harnessId, (Object)player.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && CustomHarnessManager.isSinglePlayerServer((player = (ServerPlayer)player2).getServer())) {
            CustomHarnessManager.syncAllHarnessesToPlayer(player);
        }
    }

    public static void giveCustomHarnessToPlayer(String harnessId, ServerPlayer player) {
        if (!CustomHarnessManager.isSinglePlayerServer(player.getServer())) {
            LOGGER.info("Cannot give custom harness in multiplayer to player {}", (Object)player.getName().getString());
            return;
        }
        if (player == null) {
            LOGGER.error("Cannot give custom harness: player is null.");
            return;
        }
        CustomHarnessData data = registeredHarnesses.get(harnessId);
        if (data == null) {
            LOGGER.error("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0432\u044b\u0434\u0430\u0442\u044c \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0441\u0431\u0440\u0443\u044e \u0441 ID {}", (Object)harnessId);
            return;
        }
        Item baseItem = null;
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof HarnessItem)) continue;
            baseItem = item;
            break;
        }
        if (baseItem == null) {
            LOGGER.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0441\u0431\u0440\u0443\u0438 (HarnessItem) \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0439 \u0441\u0431\u0440\u0443\u0438");
            return;
        }
        ItemStack stack = new ItemStack(baseItem);
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, customData -> {
            CompoundTag mutableTag = customData.copyTag();
            mutableTag.putString("CustomHarnessId", harnessId);
            if (data.hasSaddleTexture()) {
                mutableTag.putBoolean("HasCustomSaddleTexture", true);
            }
            if (data.hasGlassesTexture()) {
                mutableTag.putBoolean("HasCustomGlassesTexture", true);
            }
            if (data.hasAccessoryTexture()) {
                mutableTag.putBoolean("HasCustomAccessoryTexture", true);
            }
            return CustomData.of((CompoundTag)mutableTag);
        });
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)data.getName()).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
            LOGGER.warn("\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0438\u0433\u0440\u043e\u043a\u0430 {} \u043f\u043e\u043b\u043e\u043d, \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0430\u044f \u0441\u0431\u0440\u0443\u044f {} \u0432\u044b\u0431\u0440\u043e\u0448\u0435\u043d\u0430.", (Object)player.getName().getString(), (Object)harnessId);
        }
    }

    private static void loadRegistry() {
        registeredHarnesses.clear();
        Path registryPath = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(REGISTRY_FILE);
        if (!Files.exists(registryPath, new LinkOption[0])) {
            LOGGER.info("\u0424\u0430\u0439\u043b \u0440\u0435\u0435\u0441\u0442\u0440\u0430 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: {}", (Object)registryPath);
            return;
        }
        try (FileReader reader = new FileReader(registryPath.toFile());){
            JsonObject registry = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (registry == null) {
                LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c JSON \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \u0440\u0435\u0435\u0441\u0442\u0440\u0430: {}", (Object)registryPath);
                return;
            }
            int loadedCount = 0;
            for (Map.Entry entry : registry.entrySet()) {
                String id = (String)entry.getKey();
                if (!((JsonElement)entry.getValue()).isJsonObject()) {
                    LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435 \u0434\u043b\u044f ID {}: \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f JSON \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c.", (Object)id);
                    continue;
                }
                JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
                try {
                    CustomHarnessData data = new CustomHarnessData(id, obj.getAsJsonPrimitive("name").getAsString(), obj.getAsJsonPrimitive("creatorUuid").getAsString(), obj.getAsJsonPrimitive("creatorName").getAsString(), obj.getAsJsonPrimitive("hasSaddleTexture").getAsBoolean(), obj.getAsJsonPrimitive("hasGlassesTexture").getAsBoolean(), obj.getAsJsonPrimitive("hasAccessoryTexture").getAsBoolean());
                    registeredHarnesses.put(id, data);
                    ++loadedCount;
                }
                catch (Exception e) {
                    LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u043b\u044f \u0441\u0431\u0440\u0443\u0438 ID {} \u0432 \u0440\u0435\u0435\u0441\u0442\u0440\u0435: {}", (Object)id, (Object)e.getMessage());
                }
            }
            LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e {} \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u0438\u0437 \u0440\u0435\u0435\u0441\u0442\u0440\u0430.", (Object)loadedCount);
        }
        catch (Exception e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u0438\u0437 {}: {}", (Object)registryPath, (Object)e.getMessage(), (Object)e);
        }
    }

    private static void saveRegistry() {
        Path registryPath = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(REGISTRY_FILE);
        try {
            Files.createDirectories(registryPath.getParent(), new FileAttribute[0]);
            JsonObject registry = new JsonObject();
            for (Map.Entry<String, CustomHarnessData> entry : registeredHarnesses.entrySet()) {
                JsonObject obj = new JsonObject();
                CustomHarnessData data = entry.getValue();
                obj.addProperty("name", data.getName());
                obj.addProperty("creatorUuid", data.getCreatorUuid());
                obj.addProperty("creatorName", data.getCreatorName());
                obj.addProperty("hasSaddleTexture", Boolean.valueOf(data.hasSaddleTexture()));
                obj.addProperty("hasGlassesTexture", Boolean.valueOf(data.hasGlassesTexture()));
                obj.addProperty("hasAccessoryTexture", Boolean.valueOf(data.hasAccessoryTexture()));
                registry.add(entry.getKey(), (JsonElement)obj);
            }
            try (FileWriter writer = new FileWriter(registryPath.toFile());){
                GSON.toJson((JsonElement)registry, (Appendable)writer);
            }
            LOGGER.debug("\u0420\u0435\u0435\u0441\u0442\u0440 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0432 {}", (Object)registryPath);
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0441\u0431\u0440\u0443\u0439 \u0432 {}: {}", (Object)registryPath, (Object)e.getMessage(), (Object)e);
        }
    }

    private static void syncCustomHarnessToAllPlayers(CustomHarnessData data, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null || !CustomHarnessManager.isSinglePlayerServer(server)) {
            return;
        }
        SyncCustomHarnessPayload payload = new SyncCustomHarnessPayload(data.getId(), data.getName(), data.getCreatorName(), saddleTextureData, glassesTextureData, accessoryTextureData);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        LOGGER.debug("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043f\u0430\u043a\u0435\u0442 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u043d\u043e\u0432\u043e\u0439 \u0441\u0431\u0440\u0443\u0438 {} \u0432\u0441\u0435\u043c \u0438\u0433\u0440\u043e\u043a\u0430\u043c (\u0432 SP - \u043e\u0434\u043d\u043e\u043c\u0443)", (Object)data.getId());
    }

    public static CustomHarnessData getCustomHarnessData(String id) {
        return registeredHarnesses.get(id);
    }

    public static Map<String, CustomHarnessData> getAllCustomHarnesses() {
        return new HashMap<String, CustomHarnessData>(registeredHarnesses);
    }

    public static byte[] loadCustomHarnessTexture(String harnessId, String textureType) {
        if ("item".equals(textureType)) {
            LOGGER.warn("Attempted to load 'item' texture for custom harness {}, which is not supported.", (Object)harnessId);
            return null;
        }
        if (textureType == null || textureType.isEmpty() || textureType.contains("/") || textureType.contains("\\") || textureType.contains("..")) {
            LOGGER.error("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0442\u0438\u043f \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: {}", (Object)textureType);
            return null;
        }
        Path path = FMLPaths.GAMEDIR.get().resolve(CUSTOM_HARNESSES_DIR).resolve(harnessId).resolve(textureType + ".png");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u0443 \u0434\u043b\u044f \u0441\u0431\u0440\u0443\u0438 {}, \u0442\u0438\u043f {}: {}", (Object)harnessId, (Object)textureType, (Object)e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0435 \u043a \u0444\u0430\u0439\u043b\u0443 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b {}: {}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public static class CustomHarnessData {
        private final String id;
        private final String name;
        private final String creatorUuid;
        private final String creatorName;
        private final boolean hasSaddleTexture;
        private final boolean hasGlassesTexture;
        private final boolean hasAccessoryTexture;

        public CustomHarnessData(String id, String name, String creatorUuid, String creatorName, boolean hasSaddleTexture, boolean hasGlassesTexture, boolean hasAccessoryTexture) {
            this.id = id;
            this.name = name;
            this.creatorUuid = creatorUuid;
            this.creatorName = creatorName;
            this.hasSaddleTexture = hasSaddleTexture;
            this.hasGlassesTexture = hasGlassesTexture;
            this.hasAccessoryTexture = hasAccessoryTexture;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getCreatorUuid() {
            return this.creatorUuid;
        }

        public String getCreatorName() {
            return this.creatorName;
        }

        public boolean hasSaddleTexture() {
            return this.hasSaddleTexture;
        }

        public boolean hasGlassesTexture() {
            return this.hasGlassesTexture;
        }

        public boolean hasAccessoryTexture() {
            return this.hasAccessoryTexture;
        }
    }
}

