/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.container;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.ContainerInit;
import dev.nweaver.happyghastmod.item.HarnessItem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GhastContainer
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Container ghastContainer;
    @Nullable
    public final HappyGhast ghast;

    public static GhastContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        HappyGhast foundGhast = null;
        Object container = null;
        if (data != null && data.readableBytes() >= 4) {
            try {
                int entityId = data.readInt();
                if (Minecraft.getInstance().level != null) {
                    Entity entity = Minecraft.getInstance().level.getEntity(entityId);
                    if (entity instanceof HappyGhast) {
                        HappyGhast happyGhast = (HappyGhast)entity;
                        foundGhast = happyGhast;
                        if (foundGhast.getInventoryComponent() != null) {
                            container = foundGhast.getInventoryComponent();
                        }
                    } else if (entity != null) {
                        LOGGER.error("Entity with ID {} is not a HappyGhast", (Object)entityId);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while reading ghast ID from buffer", (Throwable)e);
            }
        }
        if (container == null) {
            container = new SimpleContainer(1);
        }
        return new GhastContainer(windowId, playerInventory, (Container)container, foundGhast);
    }

    public GhastContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(1), null);
    }

    public GhastContainer(int id, Inventory playerInventory, Container ghastContainer, @Nullable HappyGhast ghast) {
        super((MenuType)ContainerInit.GHAST_CONTAINER.get(), id);
        this.ghastContainer = ghastContainer;
        this.ghast = ghast;
        this.addSlot(new HarnessSlot(this, this.ghastContainer, 0, 8, 18));
        this.addPlayerInventorySlots(playerInventory);
    }

    private void addPlayerInventorySlots(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.ghast != null && this.ghast.isAlive() && (this.ghast.hasPassenger((Entity)player) || (double)player.distanceTo((Entity)this.ghast) < 8.0);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (index < this.ghastContainer.getContainerSize()) {
                if (!this.moveItemStackTo(slotStack, this.ghastContainer.getContainerSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(slotStack)) {
                if (!this.moveItemStackTo(slotStack, 0, this.ghastContainer.getContainerSize(), false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return result;
    }

    private class HarnessSlot
    extends Slot {
        public HarnessSlot(GhastContainer ghastContainer, Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() instanceof HarnessItem;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

