/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ListHappyGhastsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"happyghast").then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> ListHappyGhastsCommand.listGhasts((CommandSourceStack)context.getSource(), 30))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> ListHappyGhastsCommand.listGhasts((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))));
    }

    private static int listGhasts(CommandSourceStack source, int radius) {
        Entity entity = source.getEntity();
        if (!(entity instanceof Player)) {
            source.sendFailure((Component)Component.literal((String)"\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u0438\u0433\u0440\u043e\u043a\u043e\u043c"));
            return 0;
        }
        Player player = (Player)entity;
        ServerLevel level = source.getLevel();
        Vec3 pos = player.position();
        AABB searchArea = new AABB(pos.x - (double)radius, pos.y - (double)radius, pos.z - (double)radius, pos.x + (double)radius, pos.y + (double)radius, pos.z + (double)radius);
        List ghasts = level.getEntitiesOfClass(HappyGhast.class, searchArea);
        if (ghasts.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.happyghast.list.no_ghasts", (Object[])new Object[]{radius}), false);
            return 0;
        }
        ghasts.sort((g1, g2) -> {
            double dist1 = g1.distanceToSqr((Entity)player);
            double dist2 = g2.distanceToSqr((Entity)player);
            return Double.compare(dist1, dist2);
        });
        source.sendSuccess(() -> Component.translatable((String)"commands.happyghast.list.header", (Object[])new Object[]{ghasts.size()}), false);
        for (HappyGhast ghast : ghasts) {
            double distance = Math.sqrt(ghast.distanceToSqr((Entity)player));
            String saddleStatus = ghast.isSaddled() ? "\u00a7a(" + Component.translatable((String)"commands.happyghast.list.with_saddle").getString() + ")" : "\u00a7c(" + Component.translatable((String)"commands.happyghast.list.without_saddle").getString() + ")";
            String posString = String.format("\u00a77[%.1f, %.1f, %.1f]", ghast.getX(), ghast.getY(), ghast.getZ());
            String distString = String.format("\u00a77(%.1f blocks)", distance);
            String uuidString = ghast.getUUID().toString();
            MutableComponent uuidComponent = Component.literal((String)("\u00a7b" + uuidString)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuidString)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"commands.happyghast.list.click_to_copy"))));
            MutableComponent addMobButton = Component.literal((String)" \u00a7a[+]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/happyghast addmob " + uuidString + " zombie")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"commands.happyghast.list.add_mob"))));
            source.sendSuccess(() -> ListHappyGhastsCommand.lambda$listGhasts$7(posString, distString, saddleStatus, (Component)uuidComponent, (Component)addMobButton), false);
        }
        return ghasts.size();
    }

    private static /* synthetic */ Component lambda$listGhasts$7(String posString, String distString, String saddleStatus, Component uuidComponent, Component addMobButton) {
        return Component.literal((String)"").append(posString).append(" ").append(distString).append(" ").append(saddleStatus).append(" UUID: ").append(uuidComponent).append(addMobButton);
    }
}

