/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import dev.nweaver.happyghastmod.network.OpenHarnessCreatorPayload;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HarnessCreatorCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ghast").then(((LiteralArgumentBuilder)Commands.literal((String)"createharness").requires(source -> {
            if (!source.hasPermission(2)) {
                return false;
            }
            if (source.getServer() != null && !CustomHarnessManager.isSinglePlayerServer(source.getServer())) {
                if (source.getEntity() instanceof ServerPlayer) {
                    source.sendFailure((Component)Component.literal((String)"Custom harness creation is currently only available in single-player mode."));
                }
                return false;
            }
            return true;
        })).executes(HarnessCreatorCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!CustomHarnessManager.isSinglePlayerServer(source.getServer())) {
            source.sendFailure((Component)Component.literal((String)"Custom harness creation is currently only available in single-player mode."));
            return 0;
        }
        boolean isSinglePlayer = source.getServer().isSingleplayer();
        OpenHarnessCreatorPayload packet = new OpenHarnessCreatorPayload(isSinglePlayer);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        LOGGER.debug("Sent open harness creator packet to player {}", (Object)player.getName().getString());
        return 1;
    }
}

