/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.entity.components.GhastPlatformComponent;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class GhastRideCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_A_HAPPY_GHAST = new SimpleCommandExceptionType((Message)Component.literal((String)"\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u0430\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0421\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u043c \u0413\u0430\u0441\u0442\u043e\u043c."));
    private static final SimpleCommandExceptionType ERROR_GHAST_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.literal((String)"\u0421\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u0439 \u0413\u0430\u0441\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c UUID \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d."));
    private static final SimpleCommandExceptionType ERROR_CANNOT_SPAWN_ENTITY = new SimpleCommandExceptionType((Message)Component.literal((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430."));
    private static final SimpleCommandExceptionType ERROR_CANNOT_RIDE = new SimpleCommandExceptionType((Message)Component.literal((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0441\u0430\u0434\u0438\u0442\u044c \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u043d\u0430 \u0433\u0430\u0441\u0442\u0430."));
    private static final SimpleCommandExceptionType ERROR_GHAST_FULL = new SimpleCommandExceptionType((Message)Component.literal((String)"\u041d\u0430 \u0433\u0430\u0441\u0442\u0435 \u043d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043c\u0435\u0441\u0442."));
    private static final SimpleCommandExceptionType ERROR_GHAST_PLATFORM = new SimpleCommandExceptionType((Message)Component.literal((String)"\u041f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 \u0433\u0430\u0441\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u0430, \u043f\u043e\u0441\u0430\u0434\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430."));
    private static final SimpleCommandExceptionType ERROR_GHAST_NOT_SADDLED = new SimpleCommandExceptionType((Message)Component.literal((String)"\u0413\u0430\u0441\u0442 \u043d\u0435 \u043e\u0441\u0435\u0434\u043b\u0430\u043d."));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ghastride").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"ghastUuid", (ArgumentType)UuidArgument.uuid()).then(Commands.argument((String)"entityType", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(GhastRideCommand::executeSpawnAndRide))));
    }

    private static int executeSpawnAndRide(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        UUID ghastUuid = UuidArgument.getUuid(context, (String)"ghastUuid");
        Holder.Reference entityTypeHolder = ResourceArgument.getResource(context, (String)"entityType", (ResourceKey)Registries.ENTITY_TYPE);
        EntityType entityTypeToSpawn = (EntityType)entityTypeHolder.value();
        ServerLevel level = source.getLevel();
        Entity ghastEntity = level.getEntity(ghastUuid);
        if (ghastEntity == null) {
            throw ERROR_GHAST_NOT_FOUND.create();
        }
        if (!(ghastEntity instanceof HappyGhast)) {
            throw ERROR_NOT_A_HAPPY_GHAST.create();
        }
        HappyGhast happyGhast = (HappyGhast)ghastEntity;
        if (!happyGhast.isSaddled()) {
            throw ERROR_GHAST_NOT_SADDLED.create();
        }
        if (happyGhast.getPassengers().size() >= happyGhast.getMaxPassengers()) {
            throw ERROR_GHAST_FULL.create();
        }
        GhastPlatformComponent platformComponent = happyGhast.getPlatformComponent();
        if (platformComponent != null && platformComponent.isActive()) {
            throw ERROR_GHAST_PLATFORM.create();
        }
        Entity newEntity = entityTypeToSpawn.create((Level)level);
        if (newEntity == null) {
            throw ERROR_CANNOT_SPAWN_ENTITY.create();
        }
        Vec3 spawnPos = happyGhast.position().add(0.0, (double)happyGhast.getBbHeight() + 0.5, 0.0);
        newEntity.moveTo(spawnPos.x, spawnPos.y, spawnPos.z, happyGhast.getYRot(), 0.0f);
        if (newEntity instanceof Mob) {
            Mob mob = (Mob)newEntity;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.COMMAND, null);
        }
        if (!level.addFreshEntity(newEntity)) {
            source.sendFailure((Component)Component.literal((String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c " + newEntity.getName().getString() + " \u0432 \u043c\u0438\u0440.")));
            return 0;
        }
        boolean success = newEntity.startRiding((Entity)happyGhast, true);
        if (success) {
            source.sendSuccess(() -> Component.literal((String)("\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c " + newEntity.getName().getString() + " \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0438 \u043f\u043e\u0441\u0430\u0436\u0435\u043d\u0430 \u043d\u0430 \u0433\u0430\u0441\u0442\u0430 " + happyGhast.getName().getString())), true);
            return 1;
        }
        newEntity.discard();
        throw ERROR_CANNOT_RIDE.create();
    }
}

