/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import dev.nweaver.happyghastmod.HappyGhastMod;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientCustomHarnessManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, HarnessInfo> customHarnessInfo = new HashMap<String, HarnessInfo>();
    private static final Map<String, Map<TextureType, ResourceLocation>> customHarnessTextures = new HashMap<String, Map<TextureType, ResourceLocation>>();

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientCustomHarnessManager.clearCustomHarnesses();
    }

    public static void registerCustomHarness(String harnessId, String harnessName, String creatorName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        ResourceLocation accessoryTexture;
        ResourceLocation glassesTexture;
        ResourceLocation saddleTexture;
        customHarnessInfo.put(harnessId, new HarnessInfo(harnessId, harnessName, creatorName));
        HashMap<TextureType, ResourceLocation> textureMap = new HashMap<TextureType, ResourceLocation>();
        if (saddleTextureData != null && (saddleTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.SADDLE, saddleTextureData)) != null) {
            textureMap.put(TextureType.SADDLE, saddleTexture);
        }
        if (glassesTextureData != null && (glassesTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.GLASSES, glassesTextureData)) != null) {
            textureMap.put(TextureType.GLASSES, glassesTexture);
        }
        if (accessoryTextureData != null && (accessoryTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.ACCESSORY, accessoryTextureData)) != null) {
            textureMap.put(TextureType.ACCESSORY, accessoryTexture);
        }
        customHarnessTextures.put(harnessId, textureMap);
    }

    private static ResourceLocation registerTexture(String harnessId, TextureType type, byte[] textureData) {
        try {
            if (textureData == null || textureData.length == 0) {
                LOGGER.warn("Attempted to register null or empty texture data for harness {} type {}", (Object)harnessId, (Object)type);
                return null;
            }
            NativeImage image = NativeImage.read((InputStream)new ByteArrayInputStream(textureData));
            ResourceLocation location = HappyGhastMod.rl("textures/dynamic/" + harnessId + "_" + type.name().toLowerCase() + "_" + System.currentTimeMillis());
            DynamicTexture texture = new DynamicTexture(image);
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().getTextureManager().register(location, (AbstractTexture)texture));
            return location;
        }
        catch (IOException e) {
            LOGGER.error("Failed to register custom harness texture: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static void registerPreviewHarness(String harnessId, String harnessName, String creatorName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        try {
            customHarnessInfo.put(harnessId, new HarnessInfo(harnessId, harnessName, creatorName));
            HashMap<TextureType, ResourceLocation> textureMap = new HashMap<TextureType, ResourceLocation>();
            if (saddleTextureData != null) {
                ResourceLocation saddleTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.SADDLE, saddleTextureData);
                if (saddleTexture != null) {
                    textureMap.put(TextureType.SADDLE, saddleTexture);
                }
            } else {
                textureMap.put(TextureType.SADDLE, ClientCustomHarnessManager.getDefaultTextureForType(TextureType.SADDLE));
            }
            if (glassesTextureData != null) {
                ResourceLocation glassesTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.GLASSES, glassesTextureData);
                if (glassesTexture != null) {
                    textureMap.put(TextureType.GLASSES, glassesTexture);
                }
            } else {
                textureMap.put(TextureType.GLASSES, ClientCustomHarnessManager.getDefaultTextureForType(TextureType.GLASSES));
            }
            if (accessoryTextureData != null) {
                ResourceLocation accessoryTexture = ClientCustomHarnessManager.registerTexture(harnessId, TextureType.ACCESSORY, accessoryTextureData);
                if (accessoryTexture != null) {
                    textureMap.put(TextureType.ACCESSORY, accessoryTexture);
                }
            } else {
                textureMap.put(TextureType.ACCESSORY, ClientCustomHarnessManager.getDefaultTextureForType(TextureType.ACCESSORY));
            }
            customHarnessTextures.put(harnessId, textureMap);
        }
        catch (Exception e) {
            LOGGER.error("Error in registerPreviewHarness: {}", (Object)e.getMessage());
        }
    }

    private static ResourceLocation getDefaultTextureForType(TextureType type) {
        switch (type.ordinal()) {
            case 0: {
                return HappyGhastMod.rl("textures/entity/ghastsaddleblue.png");
            }
            case 1: {
                return HappyGhastMod.rl("textures/entity/glassestexture.png");
            }
            case 2: {
                return HappyGhastMod.rl("textures/entity/glasses_accessory.png");
            }
        }
        return HappyGhastMod.rl("textures/entity/ghastsaddleblue.png");
    }

    public static void clearCustomHarnesses() {
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        for (Map<TextureType, ResourceLocation> textureMap : customHarnessTextures.values()) {
            for (ResourceLocation location : textureMap.values()) {
                AbstractTexture texture;
                if (ClientCustomHarnessManager.isDefaultTexture(location) || (texture = textureManager.getTexture(location, null)) == null) continue;
                texture.close();
                if (!(texture instanceof DynamicTexture)) continue;
                Minecraft.getInstance().execute(() -> textureManager.release(location));
            }
        }
        customHarnessInfo.clear();
        customHarnessTextures.clear();
    }

    private static boolean isDefaultTexture(ResourceLocation location) {
        return location.equals((Object)ClientCustomHarnessManager.getDefaultTextureForType(TextureType.SADDLE)) || location.equals((Object)ClientCustomHarnessManager.getDefaultTextureForType(TextureType.GLASSES)) || location.equals((Object)ClientCustomHarnessManager.getDefaultTextureForType(TextureType.ACCESSORY));
    }

    public static HarnessInfo getCustomHarnessInfo(String harnessId) {
        return customHarnessInfo.get(harnessId);
    }

    public static ResourceLocation getHarnessTexture(String harnessId, TextureType type) {
        Map<TextureType, ResourceLocation> textureMap = customHarnessTextures.get(harnessId);
        return textureMap == null ? ClientCustomHarnessManager.getDefaultTextureForType(type) : textureMap.getOrDefault((Object)type, ClientCustomHarnessManager.getDefaultTextureForType(type));
    }

    public static boolean hasCustomTexture(String harnessId, TextureType type) {
        Map<TextureType, ResourceLocation> textureMap = customHarnessTextures.get(harnessId);
        return textureMap != null && textureMap.containsKey((Object)type) && !textureMap.get((Object)type).equals((Object)ClientCustomHarnessManager.getDefaultTextureForType(type));
    }

    public static Map<String, HarnessInfo> getAllCustomHarnesses() {
        return new HashMap<String, HarnessInfo>(customHarnessInfo);
    }

    public static void unregisterPreviewHarness(String harnessId) {
        customHarnessInfo.remove(harnessId);
        Map<TextureType, ResourceLocation> textureMap = customHarnessTextures.remove(harnessId);
        if (textureMap != null) {
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            for (ResourceLocation location : textureMap.values()) {
                AbstractTexture texture;
                if (ClientCustomHarnessManager.isDefaultTexture(location) || (texture = textureManager.getTexture(location, null)) == null) continue;
                texture.close();
                if (!(texture instanceof DynamicTexture)) continue;
                Minecraft.getInstance().execute(() -> textureManager.release(location));
            }
        }
    }

    static {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            NeoForge.EVENT_BUS.register(ClientCustomHarnessManager.class);
        }
    }

    public static class HarnessInfo {
        private final String id;
        private final String name;
        private final String creatorName;

        public HarnessInfo(String id, String name, String creatorName) {
            this.id = id;
            this.name = name;
            this.creatorName = creatorName;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getCreatorName() {
            return this.creatorName;
        }
    }

    public static enum TextureType {
        SADDLE,
        GLASSES,
        ACCESSORY;

    }
}

