/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.item.CustomHarnessItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class HappyGhastSaddleLayer
extends RenderLayer<Ghast, GhastModel<Ghast>> {
    private static final Logger LOGGER = LogManager.getLogger((String)"HappyGhastMod");
    private static final Map<String, ResourceLocation> SADDLE_TEXTURES = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation BLUE_SADDLE_TEXTURE = HappyGhastMod.rl("textures/entity/ghastsaddleblue.png");
    private final GhastModel<Ghast> model;
    private static final float Y_OFFSET = -0.05f;

    public HappyGhastSaddleLayer(RenderLayerParent<Ghast, GhastModel<Ghast>> parent, GhastModel<Ghast> model) {
        super(parent);
        this.model = model;
    }

    private ResourceLocation getSaddleTexture(String color) {
        if (color == null || color.isEmpty()) {
            return BLUE_SADDLE_TEXTURE;
        }
        if (color.startsWith("custom:")) {
            String harnessId = color.substring(7);
            ResourceLocation customTexture = ClientCustomHarnessManager.getHarnessTexture(harnessId, ClientCustomHarnessManager.TextureType.SADDLE);
            if (customTexture != null) {
                return customTexture;
            }
            return BLUE_SADDLE_TEXTURE;
        }
        return SADDLE_TEXTURES.computeIfAbsent(color, k -> {
            String fileName = "textures/entity/ghastsaddle" + color.replace("_", "") + ".png";
            return HappyGhastMod.rl(fileName);
        });
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Ghast entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        HappyGhast happyGhast;
        if (entity instanceof HappyGhast && (happyGhast = (HappyGhast)entity).isSaddled()) {
            ItemStack saddleItem;
            Object harnessColor = happyGhast.getHarnessColor();
            String customHarnessId = null;
            if (happyGhast.getInventoryComponent() != null && (saddleItem = happyGhast.getInventoryComponent().getItem(0)) != null && !saddleItem.isEmpty()) {
                if (saddleItem.getItem() instanceof CustomHarnessItem) {
                    customHarnessId = CustomHarnessItem.getCustomHarnessId(saddleItem);
                } else {
                    LOGGER.debug("Checking for custom harness ID in saddle item");
                }
            }
            if (customHarnessId != null) {
                harnessColor = "custom:" + customHarnessId;
            }
            ResourceLocation textureLocation = this.getSaddleTexture((String)harnessColor);
            ((GhastModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RenderType renderType = RenderType.entityTranslucent((ResourceLocation)textureLocation);
            VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
            poseStack.pushPose();
            poseStack.scale(1.05f, 1.05f, 1.05f);
            poseStack.translate(0.0f, -0.05f, 0.0f);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

