/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.client.model.HappyGhastModel;
import dev.nweaver.happyghastmod.client.renderer.layers.HappyGhastGlassesLayer;
import dev.nweaver.happyghastmod.client.renderer.layers.HappyGhastSaddleLayer;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.ModelLayersInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class HappyGhastRenderer
extends GhastRenderer {
    private static final ResourceLocation TEXTURE = HappyGhastMod.rl("textures/entity/happy_ghast.png");
    private static final Logger LOGGER = LogManager.getLogger(HappyGhastRenderer.class);
    private static int renderLogCounter = 0;
    private static final int LOG_INTERVAL = 50;

    public HappyGhastRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new HappyGhastModel(ctx.bakeLayer(ModelLayersInit.HAPPY_GHAST));
        HappyGhastModel<Ghast> saddleModel = new HappyGhastModel<Ghast>(ctx.bakeLayer(ModelLayersInit.HAPPY_GHAST));
        this.addLayer(new HappyGhastSaddleLayer((RenderLayerParent<Ghast, GhastModel<Ghast>>)this, saddleModel));
        HappyGhastModel<Ghast> glassesModel = new HappyGhastModel<Ghast>(ctx.bakeLayer(ModelLayersInit.HAPPY_GHAST));
        this.addLayer(new HappyGhastGlassesLayer((RenderLayerParent<Ghast, GhastModel<Ghast>>)this, glassesModel));
        System.out.println("[HappyGhastMod] HappyGhastRenderer initialized with custom tentacle model!");
    }

    public void render(Ghast entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity instanceof HappyGhast) {
            HappyGhast happyGhast = (HappyGhast)entity;
            float interpolatedYaw = Mth.rotLerp((float)partialTicks, (float)happyGhast.yRotO, (float)happyGhast.getYRot());
            float interpolatedPitch = Mth.rotLerp((float)partialTicks, (float)happyGhast.xRotO, (float)happyGhast.getXRot());
            float headYaw = Mth.rotLerp((float)partialTicks, (float)happyGhast.yHeadRotO, (float)happyGhast.yHeadRot);
            float bodyYaw = Mth.rotLerp((float)partialTicks, (float)happyGhast.yBodyRotO, (float)happyGhast.yBodyRot);
            boolean isLocalPlayerDriver = false;
            if (happyGhast.isVehicle() && Minecraft.getInstance().player != null && happyGhast.getPassengers().indexOf(Minecraft.getInstance().player) == 0) {
                isLocalPlayerDriver = true;
            }
            if (happyGhast.isVehicle() && !isLocalPlayerDriver) {
                happyGhast.yBodyRot = interpolatedYaw;
                happyGhast.yHeadRot = interpolatedYaw;
            }
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(Ghast entity) {
        return TEXTURE;
    }
}

