/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.model;

import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GhastlingModel<T extends Entity>
extends GhastModel<T> {
    public GhastlingModel(ModelPart modelPart) {
        super(modelPart);
    }

    private static String createTentacleName(int index) {
        return "tentacle" + index;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.offset((float)0.0f, (float)17.6f, (float)0.0f));
        RandomSource randomSource = RandomSource.create((long)1660L);
        int[] tentacleLengths = new int[]{4, 5, 4, 5, 6, 5, 4, 5, 4};
        for (int i = 0; i < 9; ++i) {
            float f = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float f1 = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int length = tentacleLengths[i];
            partDefinition.addOrReplaceChild(GhastlingModel.createTentacleName(i), CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, (float)length, 2.0f), PartPose.offset((float)f, (float)24.6f, (float)f1));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }
}

