/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TexturePreviewButton
extends Button {
    private final File textureFile;
    private ResourceLocation previewTexture;
    private int textureWidth;
    private int textureHeight;
    private String textureType;
    private String selectedTextureType;

    public TexturePreviewButton(File textureFile, int x, int y, int width, int height, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.literal((String)textureFile.getName()), onPress, DEFAULT_NARRATION);
        this.textureFile = textureFile;
        String fileName = textureFile.getName().toLowerCase();
        this.textureType = fileName.contains("accessory") || fileName.contains("_acc") || fileName.contains(" acc") || fileName.endsWith("acc") || fileName.contains("_accessory") || fileName.contains(" accessory") ? "accessory" : (fileName.contains("glasses") || fileName.contains("glass") || fileName.contains("_glass") || fileName.contains(" glass") ? "glasses" : (fileName.contains("saddle") || fileName.contains("_saddle") || fileName.contains(" saddle") ? "saddle" : "saddle"));
        this.selectedTextureType = this.textureType;
        this.loadPreviewTexture();
    }

    public void setSelectedTextureType(String selectedType) {
        this.selectedTextureType = selectedType;
    }

    private void loadPreviewTexture() {
        try {
            byte[] fileData = Files.readAllBytes(this.textureFile.toPath());
            NativeImage nativeImage = NativeImage.read((InputStream)new ByteArrayInputStream(fileData));
            this.textureWidth = nativeImage.getWidth();
            this.textureHeight = nativeImage.getHeight();
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            this.previewTexture = Minecraft.getInstance().getTextureManager().register("texture/" + UUID.randomUUID().toString(), dynamicTexture);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getTextureFile() {
        return this.textureFile;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int bgColor = this.isHovered ? -8947849 : -11184811;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
        if (this.previewTexture != null) {
            int indicatorX = this.getX() + 10;
            int indicatorY = this.getY() + (this.height - 10) / 2;
            int indicatorSize = 10;
            boolean isValidRatio = this.isValidAspectRatio(this.selectedTextureType);
            int indicatorColor = isValidRatio ? this.getColorForTextureType(this.selectedTextureType) : -43691;
            graphics.fill(indicatorX, indicatorY, indicatorX + indicatorSize, indicatorY + indicatorSize, indicatorColor);
            Object filename = this.textureFile.getName();
            if (((String)filename).length() > 45) {
                filename = ((String)filename).substring(0, 42) + "...";
            }
            String typeLabel = this.selectedTextureType.substring(0, 1).toUpperCase() + this.selectedTextureType.substring(1);
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.scale(0.65f, 0.65f, 0.65f);
            float scaleFactor = 0.65f;
            int scaledX = (int)((float)(this.getX() + 30) / scaleFactor);
            int scaledY = (int)((float)(this.getY() + (this.height - 8) / 2) / scaleFactor);
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(typeLabel + ": " + (String)filename)), scaledX, scaledY, this.isHovered ? 0xFFFFFF : 0xCCCCCC);
            poseStack.popPose();
        } else {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"Texture loading error"), this.getX() + 10, this.getY() + (this.height - 10) / 2, 0xFF5555);
        }
    }

    private boolean isValidAspectRatio(String textureTypeToCheck) {
        double aspectRatio = (double)this.textureWidth / (double)this.textureHeight;
        switch (textureTypeToCheck) {
            case "saddle": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
            case "glasses": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
            case "accessory": {
                return Math.abs(aspectRatio - 2.0) < 0.1;
            }
        }
        return false;
    }

    private int getColorForTextureType(String textureTypeToColor) {
        return switch (textureTypeToColor) {
            case "saddle" -> -11141291;
            case "glasses" -> -11184641;
            case "accessory" -> -171;
            default -> -1;
        };
    }
}

