/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.nweaver.happyghastmod.container.GhastContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;

public class GhastScreen
extends AbstractContainerScreen<GhastContainer> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation GHAST_INVENTORY_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/horse.png");
    private float mouseX;
    private float mouseY;
    private float modelScale = 6.0f;
    private float modelY = 0.0f;
    private float modelZ = 30.0f;
    private static final float MAX_Y_ROTATION = 30.0f;
    private static final float MAX_X_ROTATION = 15.0f;

    public GhastScreen(GhastContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int pMouseX, int pMouseY) {
        this.mouseX = pMouseX;
        this.mouseY = pMouseY;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GHAST_INVENTORY_LOCATION, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((GhastContainer)this.menu).ghast != null) {
            try {
                this.renderEntityInInventory(guiGraphics, x + 51, y + 60, (LivingEntity)((GhastContainer)this.menu).ghast);
            }
            catch (Exception e) {
                LOGGER.error("Failed to render 3D model: {}", (Object)e.getMessage());
            }
        } else {
            MutableComponent errorMessage = Component.literal((String)"\u041e\u0448\u0438\u0431\u043a\u0430: \u0433\u0430\u0441\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            int errorX = x + (this.imageWidth - this.font.width((FormattedText)errorMessage)) / 2;
            guiGraphics.drawString(this.font, (Component)errorMessage, errorX, y + 45, -65536);
            MutableComponent additionalInfo = Component.literal((String)"\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u043d\u043e\u0432\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c");
            int infoX = x + (this.imageWidth - this.font.width((FormattedText)additionalInfo)) / 2;
            guiGraphics.drawString(this.font, (Component)additionalInfo, infoX, y + 60, -22016);
        }
    }

    private void renderEntityInInventory(GuiGraphics guiGraphics, int posX, int posY, LivingEntity entity) {
        try {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)posX, (float)posY, this.modelZ);
            poseStack.scale(this.modelScale, this.modelScale, this.modelScale);
            float originalYRot = entity.getYRot();
            float originalXRot = entity.getXRot();
            float originalYHeadRot = entity.yHeadRot;
            float originalYBodyRot = entity.yBodyRot;
            entity.setYRot(0.0f);
            entity.setXRot(0.0f);
            entity.yHeadRot = 0.0f;
            entity.yBodyRot = 0.0f;
            float mousePosX = this.mouseX - (float)posX;
            float mousePosY = this.mouseY - (float)posY;
            float angleY = Mth.clamp((float)((float)Math.atan(mousePosX / 40.0f) * 20.0f), (float)-30.0f, (float)30.0f);
            float angleX = Mth.clamp((float)((float)Math.atan(mousePosY / 40.0f) * 20.0f), (float)-15.0f, (float)15.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(angleY));
            poseStack.mulPose(Axis.XP.rotationDegrees(angleX));
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(0.0, (double)this.modelY, 0.0);
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            dispatcher.overrideCameraOrientation(new Quaternionf());
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            dispatcher.setRenderShadow(false);
            RenderSystem.runAsFancy(() -> dispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.endBatch();
            dispatcher.setRenderShadow(true);
            Lighting.setupFor3DItems();
            entity.setYRot(originalYRot);
            entity.setXRot(originalXRot);
            entity.yHeadRot = originalYHeadRot;
            entity.yBodyRot = originalYBodyRot;
            poseStack.popPose();
        }
        catch (Exception e) {
            LOGGER.error("Error rendering entity: {}", (Object)e.getMessage());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent title = Component.literal((String)"Happy Ghast Inventory");
        guiGraphics.drawString(this.font, (Component)title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

