/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class EntityPreviewRenderer {
    private final HappyGhast previewEntity;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private float modelScale = 5.0f;
    private float modelY = 0.0f;
    private float modelZ = 30.0f;
    private boolean isRotating = false;
    private int lastMouseX;
    private int lastMouseY;

    public EntityPreviewRenderer(HappyGhast previewEntity) {
        this.previewEntity = previewEntity;
    }

    public void renderPreview(GuiGraphics graphics, int previewX, int previewY, int previewWidth, int previewHeight, Font font) {
        if (this.previewEntity == null) {
            return;
        }
        graphics.fill(previewX, previewY, previewX + previewWidth, previewY + previewHeight, -14671840);
        graphics.fill(previewX, previewY, previewX + previewWidth, previewY + 2, -11184811);
        graphics.fill(previewX, previewY + previewHeight - 2, previewX + previewWidth, previewY + previewHeight, -11184811);
        graphics.fill(previewX, previewY, previewX + 2, previewY + previewHeight, -11184811);
        graphics.fill(previewX + previewWidth - 2, previewY, previewX + previewWidth, previewY + previewHeight, -11184811);
        graphics.drawCenteredString(font, (Component)Component.literal((String)"Preview"), previewX + previewWidth / 2, previewY - 10, 0xFFFFFF);
        this.renderEntityInArea(graphics, previewX + previewWidth / 2, previewY + previewHeight / 2 + 15);
    }

    private void renderEntityInArea(GuiGraphics guiGraphics, int posX, int posY) {
        try {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)posX, (float)posY, this.modelZ);
            poseStack.scale(this.modelScale, this.modelScale, this.modelScale);
            float originalYRot = this.previewEntity.getYRot();
            float originalXRot = this.previewEntity.getXRot();
            float originalYHeadRot = this.previewEntity.yHeadRot;
            float originalYBodyRot = this.previewEntity.yBodyRot;
            this.previewEntity.setYRot(0.0f);
            this.previewEntity.setXRot(0.0f);
            this.previewEntity.yHeadRot = 0.0f;
            this.previewEntity.yBodyRot = 0.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(this.rotationY));
            poseStack.mulPose(Axis.XP.rotationDegrees(this.rotationX));
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(0.0, (double)this.modelY, 0.0);
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            dispatcher.overrideCameraOrientation(new Quaternionf());
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            dispatcher.setRenderShadow(false);
            RenderSystem.runAsFancy(() -> dispatcher.render((Entity)this.previewEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.endBatch();
            dispatcher.setRenderShadow(true);
            Lighting.setupFor3DItems();
            this.previewEntity.setYRot(originalYRot);
            this.previewEntity.setXRot(originalXRot);
            this.previewEntity.yHeadRot = originalYHeadRot;
            this.previewEntity.yBodyRot = originalYBodyRot;
            poseStack.popPose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInPreviewArea(double mouseX, double mouseY, int previewX, int previewY, int previewWidth, int previewHeight) {
        return mouseX >= (double)previewX && mouseX <= (double)(previewX + previewWidth) && mouseY >= (double)previewY && mouseY <= (double)(previewY + previewHeight);
    }

    public void startRotating(int mouseX, int mouseY) {
        this.isRotating = true;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void stopRotating() {
        this.isRotating = false;
    }

    public void updateRotation(int mouseX, int mouseY) {
        this.rotationY += (float)(mouseX - this.lastMouseX) * 2.0f;
        this.rotationX += (float)(mouseY - this.lastMouseY) * 2.0f;
        this.rotationX = Mth.clamp((float)this.rotationX, (float)-30.0f, (float)30.0f);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean isRotating() {
        return this.isRotating;
    }

    public HappyGhast getPreviewEntity() {
        return this.previewEntity;
    }
}

