/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client.gui;

import dev.nweaver.happyghastmod.client.gui.EntityPreviewRenderer;
import dev.nweaver.happyghastmod.client.gui.HarnessTextureManager;
import dev.nweaver.happyghastmod.client.gui.StatusMessageManager;
import dev.nweaver.happyghastmod.client.gui.TexturePreviewButton;
import dev.nweaver.happyghastmod.client.gui.TextureUtils;
import dev.nweaver.happyghastmod.client.gui.UILayoutHelper;
import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.network.NetworkHandler;
import dev.nweaver.happyghastmod.network.RegisterCustomHarnessPayload;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomHarnessCreator
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PREVIEW_HARNESS_ID = "preview-harness-id";
    private final UILayoutHelper layout;
    private final HarnessTextureManager textureManager;
    private final EntityPreviewRenderer entityRenderer;
    private final StatusMessageManager statusManager;
    private EditBox harnessNameField;
    private List<TexturePreviewButton> textureButtons = new ArrayList<TexturePreviewButton>();
    private String currentTextureType = "saddle";
    private int scrollOffset = 0;
    private int maxTexturesVisible = 3;

    public CustomHarnessCreator() {
        super((Component)Component.literal((String)"Create Custom Harness"));
        this.layout = new UILayoutHelper();
        this.textureManager = new HarnessTextureManager(PREVIEW_HARNESS_ID);
        this.statusManager = new StatusMessageManager();
        HappyGhast previewGhast = null;
        try {
            if (Minecraft.getInstance().level != null && (previewGhast = (HappyGhast)((EntityType)EntityInit.HAPPY_GHAST.get()).create((Level)Minecraft.getInstance().level)) != null) {
                previewGhast.setSaddled(true);
                previewGhast.setHarnessColor("blue");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entityRenderer = new EntityPreviewRenderer(previewGhast);
        try {
            ClientCustomHarnessManager.unregisterPreviewHarness(PREVIEW_HARNESS_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void init() {
        this.layout.calculateLayout(this.width, this.height);
        this.harnessNameField = new EditBox(this.font, this.layout.getNameFieldX(), this.layout.getNameFieldY(), this.layout.getNameFieldWidth(), 20, (Component)Component.empty());
        this.harnessNameField.setMaxLength(32);
        this.harnessNameField.setValue("");
        this.harnessNameField.setHint((Component)Component.literal((String)"Enter harness name"));
        this.addRenderableWidget((GuiEventListener)this.harnessNameField);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Open Folder"), button -> this.openTexturesFolder()).pos(this.layout.getFolderButtonX(), this.layout.getFolderButtonY()).size(90, 20).build());
        this.addTextureTypeButtons();
        this.addNavigationButtons();
        this.addActionButtons();
        this.refreshTextureList();
        this.textureManager.setPreviewUpdateCallback(new HarnessTextureManager.PreviewUpdateCallback(){

            @Override
            public void onTextureSelected() {
                Minecraft.getInstance().execute(() -> {
                    String previewName = CustomHarnessCreator.this.harnessNameField.getValue().isEmpty() ? "\u041f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440" : CustomHarnessCreator.this.harnessNameField.getValue();
                    CustomHarnessCreator.this.updatePreviewHarness();
                });
            }
        });
    }

    private void addTextureTypeButtons() {
        int tabWidth = 60;
        int tabHeight = 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Saddle"), button -> this.selectTextureType("saddle")).pos(this.layout.getTypeButtonX(), this.layout.getTypeButtonY()).size(tabWidth, tabHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Glasses"), button -> this.selectTextureType("glasses")).pos(this.layout.getTypeButtonX() + tabWidth + 5, this.layout.getTypeButtonY()).size(tabWidth, tabHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Accessory"), button -> this.selectTextureType("accessory")).pos(this.layout.getTypeButtonX(), this.layout.getTypeButtonY() + tabHeight + 5).size(tabWidth, tabHeight).build());
    }

    private void addNavigationButtons() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25c0"), button -> this.scrollUp()).pos(this.layout.getLeftNavButtonX(), this.layout.getNavButtonY()).size(30, 30).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25b6"), button -> this.scrollDown()).pos(this.layout.getRightNavButtonX(), this.layout.getNavButtonY()).size(30, 30).build());
    }

    private void addActionButtons() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"CREATE HARNESS"), button -> this.createHarness()).pos(this.layout.getCreateButtonX(), this.layout.getCreateButtonY()).size(130, 30).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.onClose()).pos(this.layout.getCancelButtonX(), this.layout.getCancelButtonY()).size(70, 25).build());
    }

    public void onClose() {
        try {
            ClientCustomHarnessManager.unregisterPreviewHarness(PREVIEW_HARNESS_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onClose();
    }

    private void refreshTextureList() {
        for (TexturePreviewButton button : this.textureButtons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.textureButtons.clear();
        List<File> textures = TextureUtils.getAvailableTextures();
        if (textures.isEmpty()) {
            return;
        }
        this.maxTexturesVisible = 1;
        int maxScrollOffset = Math.max(0, textures.size() - this.maxTexturesVisible);
        this.scrollOffset = Math.min(this.scrollOffset, maxScrollOffset);
        if (this.scrollOffset < textures.size()) {
            File file = textures.get(this.scrollOffset);
            TexturePreviewButton button = new TexturePreviewButton(file, this.layout.getTextureButtonX(), this.layout.getTextureButtonY(), this.layout.getTextureButtonWidth(), this.layout.getTextureButtonHeight(), b -> this.selectTexture(((TexturePreviewButton)b).getTextureFile()));
            button.setSelectedTextureType(this.currentTextureType);
            this.textureButtons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    private void selectTextureType(String textureType) {
        this.currentTextureType = textureType;
        for (TexturePreviewButton button : this.textureButtons) {
            button.setSelectedTextureType(textureType);
        }
        this.statusManager.showStatus((Component)Component.literal((String)("Selected texture type: " + textureType)), 0x55FFFF);
    }

    private void selectTexture(File textureFile) {
        this.textureManager.selectTexture(textureFile, this.currentTextureType);
        this.updatePreviewHarness();
    }

    private void updatePreviewHarness() {
        String previewName = this.harnessNameField.getValue().isEmpty() ? "Preview" : this.harnessNameField.getValue();
        this.textureManager.updatePreviewHarness(previewName, this.entityRenderer.getPreviewEntity());
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.refreshTextureList();
        }
    }

    private void scrollDown() {
        List<File> textures = TextureUtils.getAvailableTextures();
        int maxScrollOffset = Math.max(0, textures.size() - this.maxTexturesVisible);
        if (this.scrollOffset < maxScrollOffset) {
            ++this.scrollOffset;
            this.refreshTextureList();
        }
    }

    private void openTexturesFolder() {
        File folder = TextureUtils.getTexturesFolder();
        try {
            Desktop.getDesktop().open(folder);
        }
        catch (Exception e) {
            this.statusManager.showStatus((Component)Component.literal((String)("Folder: " + folder.getAbsolutePath())), 0xFFFFAA);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.layout.renderMainPanel(graphics, this.font, this.title);
        graphics.drawString(this.font, (Component)Component.literal((String)"Name:"), this.layout.getNameLabelX(), this.layout.getNameLabelY(), 0xFFFFFF);
        this.entityRenderer.renderPreview(graphics, this.layout.getPreviewX(), this.layout.getPreviewY(), this.layout.getPreviewWidth(), this.layout.getPreviewHeight(), this.font);
        this.renderTextureSelectionArea(graphics);
        this.textureManager.renderSelectedTexturesBlock(graphics, this.layout, this.font);
        this.statusManager.renderStatusMessage(graphics, this.font, this.layout.getStatusX(), this.layout.getStatusY());
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private void renderTextureSelectionArea(GuiGraphics graphics) {
        int textureAreaY = this.layout.getTextureAreaY();
        String currentTypeLabel = switch (this.currentTextureType) {
            case "saddle" -> "Selecting Saddle Texture";
            case "glasses" -> "Selecting Glasses Texture";
            case "accessory" -> "Selecting Accessory Texture";
            default -> "Select Texture";
        };
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)currentTypeLabel), this.layout.getLeftX() + this.layout.getGuiWidth() / 2, textureAreaY + 5, 0xFFFF55);
        List<File> textures = TextureUtils.getAvailableTextures();
        if (!textures.isEmpty()) {
            String counter = this.scrollOffset + 1 + "/" + textures.size();
            graphics.drawString(this.font, (Component)Component.literal((String)counter), this.layout.getLeftX() + this.layout.getGuiWidth() / 2 - 15, textureAreaY + 20, 0xCCCCCC);
        }
        graphics.fill(this.layout.getLeftX() + 15, textureAreaY + this.layout.getTextureAreaHeight(), this.layout.getLeftX() + this.layout.getGuiWidth() - 15, textureAreaY + this.layout.getTextureAreaHeight() + 2, -11184811);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.entityRenderer.isInPreviewArea(mouseX, mouseY, this.layout.getPreviewX(), this.layout.getPreviewY(), this.layout.getPreviewWidth(), this.layout.getPreviewHeight())) {
            this.entityRenderer.startRotating((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.entityRenderer.stopRotating();
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.entityRenderer.isRotating()) {
            this.entityRenderer.updateRotation((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void createHarness() {
        String harnessName = this.harnessNameField.getValue().trim();
        if (harnessName.isEmpty()) {
            this.statusManager.showStatus((Component)Component.literal((String)"Please enter a harness name"), 0xFF5555);
            return;
        }
        if (!this.validateAllTexturesAspectRatio()) {
            return;
        }
        String harnessId = UUID.randomUUID().toString();
        try {
            NetworkHandler.sendToServer(new RegisterCustomHarnessPayload(harnessId, harnessName, this.textureManager.getSaddleTextureData(), this.textureManager.getGlassesTextureData(), this.textureManager.getAccessoryTextureData()));
            this.statusManager.showStatus((Component)Component.literal((String)"Harness created successfully!"), 0x55FF55);
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                    Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen(null));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception e) {
            this.statusManager.showStatus((Component)Component.literal((String)"Error creating harness"), 0xFF5555);
        }
    }

    private boolean validateAllTexturesAspectRatio() {
        if (this.textureManager.getSaddleTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getSaddleTextureData(), "saddle")) {
            this.statusManager.showStatus((Component)Component.literal((String)"Saddle texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        if (this.textureManager.getGlassesTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getGlassesTextureData(), "glasses")) {
            this.statusManager.showStatus((Component)Component.literal((String)"Glasses texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        if (this.textureManager.getAccessoryTextureData() != null && !TextureUtils.validateTextureAspectRatio(this.textureManager.getAccessoryTextureData(), "accessory")) {
            this.statusManager.showStatus((Component)Component.literal((String)"Accessory texture must have 2:1 aspect ratio"), 0xFF5555);
            return false;
        }
        return true;
    }
}

