/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.client;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import dev.nweaver.happyghastmod.network.OpenGhastInventoryPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientGhastInventoryHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleClientKeyInput(Entity entity) {
        if (entity instanceof HappyGhast) {
            HappyGhast ghast = (HappyGhast)entity;
            if (ghast.level().isClientSide) {
                LOGGER.debug("Sending request to open ghast inventory for entity ID: {}", (Object)ghast.getId());
                OpenGhastInventoryPayload payload = new OpenGhastInventoryPayload(ghast.getId());
                PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

