/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.block.entity;

import dev.nweaver.happyghastmod.block.GhastlingIncubatorBlock;
import dev.nweaver.happyghastmod.entity.Ghastling;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class GhastlingIncubatorBlockEntity
extends BlockEntity {
    public static final int TARGET_INCUBATION_TICKS = 24000;
    private static final int ACCELERATION_TICKS_PER_USE = 2400;
    private int incubationTicks = 0;
    private GhastlingIncubatorBlock.IncubationStage lastStage = GhastlingIncubatorBlock.IncubationStage.DRIED;
    private boolean wasWaterlogged = false;
    private int ambientSoundTimer = 0;
    private static final int AMBIENT_SOUND_INTERVAL = 200;

    public GhastlingIncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.GHASTLING_INCUBATOR.get(), pos, state);
        if (state.hasProperty((Property)GhastlingIncubatorBlock.WATERLOGGED)) {
            this.wasWaterlogged = (Boolean)state.getValue((Property)GhastlingIncubatorBlock.WATERLOGGED);
        }
        if (state.hasProperty(GhastlingIncubatorBlock.INCUBATION_STAGE)) {
            this.lastStage = (GhastlingIncubatorBlock.IncubationStage)((Object)state.getValue(GhastlingIncubatorBlock.INCUBATION_STAGE));
        }
    }

    public int getIncubationTicks() {
        return this.incubationTicks;
    }

    public boolean accelerateIncubation() {
        if (this.level == null || this.level.isClientSide) {
            return false;
        }
        if (this.incubationTicks >= 24000) {
            return false;
        }
        this.incubationTicks += 2400;
        this.incubationTicks = Mth.clamp((int)this.incubationTicks, (int)0, (int)24000);
        this.updateIncubationStage();
        this.setChanged();
        if (this.incubationTicks >= 24000) {
            SoundEvent spawnSound = (SoundEvent)SoundInit.GHASTLING_SPAWN.get();
            if (spawnSound != null) {
                this.level.playSound(null, this.worldPosition, spawnSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            GhastlingIncubatorBlockEntity.spawnGhastling(this.level, this.worldPosition);
            this.level.destroyBlock(this.worldPosition, false);
            return true;
        }
        return false;
    }

    private void updateIncubationStage() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState currentState = this.level.getBlockState(this.worldPosition);
            if (!(currentState.getBlock() instanceof GhastlingIncubatorBlock)) {
                return;
            }
            GhastlingIncubatorBlock.IncubationStage currentStage = GhastlingIncubatorBlock.getStageFromProgress(this.incubationTicks, 24000);
            if (currentStage != this.lastStage) {
                SoundEvent changeSound = (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get();
                if (changeSound != null) {
                    this.level.playSound(null, this.worldPosition, changeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue(GhastlingIncubatorBlock.INCUBATION_STAGE, (Comparable)((Object)currentStage)), 3);
                this.lastStage = currentStage;
                this.setChanged();
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GhastlingIncubatorBlockEntity blockEntity) {
        if (!(state.getBlock() instanceof GhastlingIncubatorBlock)) {
            return;
        }
        boolean isWaterlogged = (Boolean)state.getValue((Property)GhastlingIncubatorBlock.WATERLOGGED);
        if (isWaterlogged != blockEntity.wasWaterlogged) {
            SoundEvent changeSound = (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get();
            if (changeSound != null) {
                level.playSound(null, pos, changeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            blockEntity.wasWaterlogged = isWaterlogged;
            blockEntity.setChanged();
        }
        ++blockEntity.ambientSoundTimer;
        if (blockEntity.ambientSoundTimer >= 200) {
            blockEntity.ambientSoundTimer = 0;
            GhastlingIncubatorBlock.playAmbientSound(level, pos, isWaterlogged);
        }
        if (blockEntity.incubationTicks >= 24000) {
            return;
        }
        if (isWaterlogged) {
            ++blockEntity.incubationTicks;
            blockEntity.updateIncubationStage();
            if (blockEntity.incubationTicks >= 24000) {
                SoundEvent spawnSound = (SoundEvent)SoundInit.GHASTLING_SPAWN.get();
                if (spawnSound != null) {
                    level.playSound(null, pos, spawnSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                GhastlingIncubatorBlockEntity.spawnGhastling(level, pos);
                level.destroyBlock(pos, false);
            } else {
                blockEntity.setChanged();
            }
        } else if (blockEntity.incubationTicks > 0 || blockEntity.lastStage != GhastlingIncubatorBlock.IncubationStage.DRIED) {
            boolean changed = false;
            if (blockEntity.incubationTicks > 0) {
                blockEntity.incubationTicks = 0;
                changed = true;
            }
            if (blockEntity.lastStage != GhastlingIncubatorBlock.IncubationStage.DRIED) {
                SoundEvent changeSound = (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get();
                if (changeSound != null) {
                    level.playSound(null, pos, changeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                level.setBlock(pos, (BlockState)state.setValue(GhastlingIncubatorBlock.INCUBATION_STAGE, (Comparable)((Object)GhastlingIncubatorBlock.IncubationStage.DRIED)), 3);
                blockEntity.lastStage = GhastlingIncubatorBlock.IncubationStage.DRIED;
                changed = true;
            }
            if (changed) {
                blockEntity.setChanged();
            }
        }
    }

    private static void spawnGhastling(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType ghastlingType = (EntityType)EntityInit.GHASTLING.get();
            if (ghastlingType == null) {
                System.err.println("Ghastling EntityType is null!");
                return;
            }
            Vec3 spawnPos = Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.1, 0.0);
            Ghastling ghastling = (Ghastling)ghastlingType.create((Level)serverLevel);
            if (ghastling != null) {
                ghastling.setPos(spawnPos.x(), spawnPos.y(), spawnPos.z());
                if (!serverLevel.addFreshEntity((Entity)ghastling)) {
                    System.err.println("Failed to add Ghastling to world at " + String.valueOf(pos));
                }
            } else {
                System.err.println("Failed to create Ghastling instance for incubator at " + String.valueOf(pos));
            }
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("IncubationTicks", this.incubationTicks);
        pTag.putString("LastStage", this.lastStage.getSerializedName());
        pTag.putBoolean("WasWaterlogged", this.wasWaterlogged);
        pTag.putInt("AmbientSoundTimer", this.ambientSoundTimer);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.incubationTicks = pTag.getInt("IncubationTicks");
        this.wasWaterlogged = pTag.getBoolean("WasWaterlogged");
        this.ambientSoundTimer = pTag.getInt("AmbientSoundTimer");
        if (pTag.contains("LastStage", 8)) {
            String stageName = pTag.getString("LastStage");
            GhastlingIncubatorBlock.IncubationStage loadedStage = GhastlingIncubatorBlock.IncubationStage.DRIED;
            for (GhastlingIncubatorBlock.IncubationStage stage : GhastlingIncubatorBlock.IncubationStage.values()) {
                if (!stage.getSerializedName().equals(stageName)) continue;
                loadedStage = stage;
                break;
            }
            this.lastStage = loadedStage;
        } else {
            this.lastStage = GhastlingIncubatorBlock.IncubationStage.DRIED;
        }
    }
}

