/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.nweaver.happyghastmod.block.entity.GhastlingIncubatorBlockEntity;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.ItemInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GhastlingIncubatorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<GhastlingIncubatorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GhastlingIncubatorBlock.propertiesCodec()).apply((Applicative)instance, GhastlingIncubatorBlock::new));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<IncubationStage> INCUBATION_STAGE = EnumProperty.create((String)"incubation_stage", IncubationStage.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = GhastlingIncubatorBlock.createShapeForDirection(Direction.NORTH);
    private static final VoxelShape SHAPE_EAST = GhastlingIncubatorBlock.createShapeForDirection(Direction.EAST);
    private static final VoxelShape SHAPE_SOUTH = GhastlingIncubatorBlock.createShapeForDirection(Direction.SOUTH);
    private static final VoxelShape SHAPE_WEST = GhastlingIncubatorBlock.createShapeForDirection(Direction.WEST);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    private static VoxelShape createShapeForDirection(Direction direction) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125));
        switch (direction) {
            case NORTH: {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.125, (double)0.4375));
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.125, (double)0.75));
                break;
            }
            case EAST: {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.0, (double)0.0625, (double)0.6875, (double)0.125, (double)0.9375));
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.0625, (double)0.375, (double)0.125, (double)0.9375));
                break;
            }
            case SOUTH: {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.125, (double)0.6875));
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.25, (double)0.9375, (double)0.125, (double)0.375));
                break;
            }
            case WEST: {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.0625, (double)0.4375, (double)0.125, (double)0.9375));
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.0625, (double)0.75, (double)0.125, (double)0.9375));
                break;
            }
            default: {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.125, (double)0.4375));
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.125, (double)0.75));
            }
        }
        return shape;
    }

    public GhastlingIncubatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(INCUBATION_STAGE, (Comparable)((Object)IncubationStage.DRIED))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, INCUBATION_STAGE, FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    public static BlockState setIncubationStage(BlockState state, IncubationStage stage) {
        return (BlockState)state.setValue(INCUBATION_STAGE, (Comparable)((Object)stage));
    }

    public static IncubationStage getStageFromProgress(int progress, int targetProgress) {
        if (targetProgress <= 0) {
            return IncubationStage.DRIED;
        }
        float percentage = (float)progress / (float)targetProgress * 100.0f;
        if (percentage >= 66.7f) {
            return IncubationStage.HAPPY;
        }
        if (percentage >= 33.3f) {
            return IncubationStage.NEUTRAL;
        }
        return IncubationStage.DRIED;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof GhastlingIncubatorBlockEntity) {
            GhastlingIncubatorBlockEntity incubatorBe = (GhastlingIncubatorBlockEntity)blockEntity;
            if (stack.is(Items.GHAST_TEAR)) {
                boolean isWaterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
                int currentTicks = incubatorBe.getIncubationTicks();
                int targetTicks = 24000;
                if (isWaterlogged && currentTicks < targetTicks) {
                    boolean didComplete = incubatorBe.accelerateIncubation();
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    level.playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 10, 0.3, 0.3, 0.3, 0.05);
                    }
                    this.updateIncubationStage(level, pos, incubatorBe);
                    if (didComplete) {
                        player.sendSystemMessage((Component)Component.literal((String)"Incubation complete!").withStyle(ChatFormatting.LIGHT_PURPLE));
                    }
                    return ItemInteractionResult.CONSUME;
                }
                if (!isWaterlogged) {
                    player.sendSystemMessage((Component)Component.literal((String)"Incubator must be waterlogged to accelerate.").withStyle(ChatFormatting.YELLOW));
                    return ItemInteractionResult.FAIL;
                }
                player.sendSystemMessage((Component)Component.literal((String)"Incubation is already complete.").withStyle(ChatFormatting.GRAY));
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (stack.is(Items.STICK)) {
                int currentTicks = incubatorBe.getIncubationTicks();
                int targetTicks = 24000;
                if (targetTicks > 0) {
                    int progressPercent = (int)((double)currentTicks / (double)targetTicks * 100.0);
                    long remainingSeconds = (long)(targetTicks - currentTicks) / 20L;
                    long remainingMinutes = remainingSeconds / 60L;
                    boolean isWaterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
                    MutableComponent message = isWaterlogged ? Component.literal((String)"Incubation progress: ").append((Component)Component.literal((String)(progressPercent + "%")).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)" (approx. ")).append((Component)Component.literal((String)String.format("%d min %d sec", remainingMinutes, remainingSeconds %= 60L)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)" remaining while waterlogged)")) : Component.literal((String)"Incubator must be waterlogged. Progress: ").append((Component)Component.literal((String)(progressPercent + "%")).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"."));
                    player.sendSystemMessage((Component)message);
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Incubation target time not set correctly.").withStyle(ChatFormatting.RED));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    private void updateIncubationStage(Level level, BlockPos pos, GhastlingIncubatorBlockEntity entity) {
        IncubationStage newStage;
        BlockState currentState;
        IncubationStage oldStage;
        if (!level.isClientSide && (oldStage = (IncubationStage)((Object)(currentState = level.getBlockState(pos)).getValue(INCUBATION_STAGE))) != (newStage = GhastlingIncubatorBlock.getStageFromProgress(entity.getIncubationTicks(), 24000))) {
            SoundEvent sound = (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get();
            if (sound != null) {
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.setBlock(pos, (BlockState)currentState.setValue(INCUBATION_STAGE, (Comparable)((Object)newStage)), 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean isWater = fluidstate.getType() == Fluids.WATER;
        Direction direction = context.getHorizontalDirection().getOpposite();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!level.isClientSide()) {
            SoundEvent sound;
            SoundEvent soundEvent = sound = isWater ? (SoundEvent)SoundInit.DRIED_GHAST_PLACE_IN_WATER.get() : null;
            if (isWater && sound != null) {
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.8f, 0.96f);
            }
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).setValue(INCUBATION_STAGE, (Comparable)((Object)IncubationStage.DRIED))).setValue((Property)FACING, (Comparable)direction);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        Level level;
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).isClientSide()) {
            boolean isNowWaterlogged;
            boolean wasWaterlogged = (Boolean)stateIn.getValue((Property)WATERLOGGED);
            FluidState fluidNow = levelAccessor.getFluidState(currentPos);
            boolean bl = isNowWaterlogged = fluidNow.getType() == Fluids.WATER;
            if (wasWaterlogged != isNowWaterlogged) {
                SoundEvent sound = (SoundEvent)SoundInit.DRIED_GHAST_STATE_CHANGE.get();
                if (sound != null) {
                    level.playSound(null, currentPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return super.updateShape((BlockState)stateIn.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isNowWaterlogged)), facing, facingState, levelAccessor, currentPos, facingPos);
            }
        }
        return super.updateShape(stateIn, facing, facingState, levelAccessor, currentPos, facingPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GhastlingIncubatorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return GhastlingIncubatorBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.GHASTLING_INCUBATOR.get()), GhastlingIncubatorBlockEntity::serverTick);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (!level.isClientSide) {
            SoundEvent sound = (SoundEvent)SoundInit.DRIED_GHAST_BREAK.get();
            if (sound != null) {
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.8f, 0.96f);
            }
            if (blockEntity instanceof GhastlingIncubatorBlockEntity) {
                GhastlingIncubatorBlockEntity incubator = (GhastlingIncubatorBlockEntity)blockEntity;
                int progress = incubator.getIncubationTicks();
                int maxProgress = 24000;
                ItemStack dropStack = new ItemStack((ItemLike)ItemInit.GHASTLING_INCUBATOR_ITEM.get());
                if (progress > 0 && maxProgress > 0) {
                    CompoundTag nbtData = new CompoundTag();
                    nbtData.putInt("IncubationProgress", progress);
                    CustomData customComponentData = CustomData.of((CompoundTag)nbtData);
                    dropStack.set(DataComponents.CUSTOM_DATA, (Object)customComponentData);
                }
                GhastlingIncubatorBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)dropStack);
            }
        }
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        SoundEvent sound;
        if (!level.isClientSide && (sound = (SoundEvent)SoundInit.DRIED_GHAST_HIT.get()) != null) {
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.2f, 0.6f);
        }
        super.attack(state, level, pos, player);
    }

    public static void playAmbientSound(Level level, BlockPos pos, boolean isWaterlogged) {
        if (!level.isClientSide && level.random.nextInt(300) < 5) {
            SoundEvent sound;
            SoundEvent soundEvent = sound = isWaterlogged ? (SoundEvent)SoundInit.DRIED_GHAST_AMBIENT_WATER.get() : (SoundEvent)SoundInit.DRIED_GHAST_AMBIENT.get();
            if (sound != null) {
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public static enum IncubationStage implements StringRepresentable
    {
        DRIED("dried"),
        NEUTRAL("neutral"),
        HAPPY("happy");

        private final String name;

        private IncubationStage(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

