/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod;

import com.mojang.brigadier.CommandDispatcher;
import dev.nweaver.happyghastmod.client.gui.GhastScreen;
import dev.nweaver.happyghastmod.command.GhastRideCommand;
import dev.nweaver.happyghastmod.command.GhastSpeedCommand;
import dev.nweaver.happyghastmod.command.HarnessCreatorCommand;
import dev.nweaver.happyghastmod.command.ListHappyGhastsCommand;
import dev.nweaver.happyghastmod.core.registration.ModBiomeModifiers;
import dev.nweaver.happyghastmod.core.registration.ModFeatures;
import dev.nweaver.happyghastmod.init.BlockEntityInit;
import dev.nweaver.happyghastmod.init.BlockInit;
import dev.nweaver.happyghastmod.init.ContainerInit;
import dev.nweaver.happyghastmod.init.CreativeTabInit;
import dev.nweaver.happyghastmod.init.EntityInit;
import dev.nweaver.happyghastmod.init.ItemInit;
import dev.nweaver.happyghastmod.init.RecipeInit;
import dev.nweaver.happyghastmod.init.SoundInit;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="happyghastmod")
public class HappyGhastMod {
    public static final String MODID = "happyghastmod";
    public static final Logger LOGGER = LogManager.getLogger((String)"happyghastmod");

    public HappyGhastMod(IEventBus modEventBus) {
        LOGGER.info("Initializing Happy Ghast Mod");
        EntityInit.ENTITIES.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
        CreativeTabInit.TABS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        ContainerInit.CONTAINERS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        SoundInit.register(modEventBus);
        RecipeInit.RECIPE_SERIALIZERS.register(modEventBus);
        RecipeInit.RECIPE_TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerScreens);
        }
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        LOGGER.info("Mod initialization complete");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Running common setup");
        event.enqueueWork(() -> LOGGER.debug("Common setup enqueued work complete."));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Running client setup");
        event.enqueueWork(() -> LOGGER.debug("Client setup enqueued work complete."));
    }

    @SubscribeEvent
    public void registerScreens(RegisterMenuScreensEvent event) {
        LOGGER.info("Registering menu screens");
        event.register((MenuType)ContainerInit.GHAST_CONTAINER.get(), GhastScreen::new);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        LOGGER.info("Registering commands");
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext buildContext = event.getBuildContext();
        ListHappyGhastsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        GhastRideCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        HarnessCreatorCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        GhastSpeedCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

