/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastbench.net;

import dev.shadowsoffire.fastbench.FastBench;
import dev.shadowsoffire.fastbench.api.ICraftingContainer;
import dev.shadowsoffire.fastbench.api.ICraftingScreen;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public record RecipePayload(ResourceLocation recipeId, ItemStack output) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RecipePayload> TYPE = new CustomPacketPayload.Type(FastBench.loc("recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipePayload> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, RecipePayload::recipeId, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, RecipePayload::output, RecipePayload::new);
    public static final ResourceLocation NULL = ResourceLocation.fromNamespaceAndPath((String)"null", (String)"null");

    public RecipePayload(@Nullable RecipeHolder<CraftingRecipe> recipe, ItemStack output) {
        this(recipe == null ? NULL : recipe.id(), output);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Provider
    implements PayloadProvider<RecipePayload> {
        public CustomPacketPayload.Type<RecipePayload> getType() {
            return TYPE;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, RecipePayload> getCodec() {
            return CODEC;
        }

        public void handle(RecipePayload msg, IPayloadContext ctx) {
            RecipeHolder recipe = Minecraft.getInstance().level.getRecipeManager().byKey(msg.recipeId).orElse(null);
            if (Minecraft.getInstance().screen instanceof ICraftingScreen) {
                ICraftingContainer c = ((ICraftingScreen)Minecraft.getInstance().screen).getContainer();
                Provider.updateLastRecipe(c.getResult(), (RecipeHolder<CraftingRecipe>)recipe, msg.output);
            } else if (Minecraft.getInstance().screen instanceof InventoryScreen) {
                InventoryMenu c = (InventoryMenu)((InventoryScreen)Minecraft.getInstance().screen).getMenu();
                Provider.updateLastRecipe(c.resultSlots, (RecipeHolder<CraftingRecipe>)recipe, msg.output);
            }
        }

        public List<ConnectionProtocol> getSupportedProtocols() {
            return List.of(ConnectionProtocol.PLAY);
        }

        public Optional<PacketFlow> getFlow() {
            return Optional.of(PacketFlow.CLIENTBOUND);
        }

        public boolean isOptional() {
            return false;
        }

        public static void updateLastRecipe(ResultContainer craftResult, RecipeHolder<CraftingRecipe> recipe, ItemStack output) {
            craftResult.setRecipeUsed(recipe);
            craftResult.setItem(0, output);
        }

        public String getVersion() {
            return "1";
        }
    }
}

