/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.ScrollItemScaling;
import yalter.mousetweaks.WheelScrollDirection;
import yalter.mousetweaks.WheelSearchOrder;

public class Config {
    private static final Properties defaultValues = new Properties();
    private String fileName;
    public boolean rmbTweak = true;
    public boolean lmbTweakWithItem = true;
    public boolean lmbTweakWithoutItem = true;
    public boolean wheelTweak = true;
    public WheelSearchOrder wheelSearchOrder = WheelSearchOrder.LAST_TO_FIRST;
    public WheelScrollDirection wheelScrollDirection = WheelScrollDirection.NORMAL;
    public ScrollItemScaling scrollItemScaling = ScrollItemScaling.PROPORTIONAL;
    public static boolean debug = false;

    Config(String fileName) {
        this.fileName = fileName;
    }

    public void read() {
        Properties properties = new Properties(defaultValues);
        try {
            FileReader configReader = new FileReader(this.fileName);
            properties.load(configReader);
            configReader.close();
        }
        catch (FileNotFoundException ignored) {
            Logger.Log("Generating the config file at: " + this.fileName);
            this.save();
            return;
        }
        catch (IOException e) {
            Logger.Log("Failed to read the config file: " + this.fileName);
            e.printStackTrace();
        }
        this.rmbTweak = Config.parseIntOrDefault(properties.getProperty("RMBTweak"), 1) != 0;
        this.lmbTweakWithItem = Config.parseIntOrDefault(properties.getProperty("LMBTweakWithItem"), 1) != 0;
        this.lmbTweakWithoutItem = Config.parseIntOrDefault(properties.getProperty("LMBTweakWithoutItem"), 1) != 0;
        this.wheelTweak = Config.parseIntOrDefault(properties.getProperty("WheelTweak"), 1) != 0;
        this.wheelSearchOrder = WheelSearchOrder.fromId(Config.parseIntOrDefault(properties.getProperty("WheelSearchOrder"), 1));
        this.wheelScrollDirection = WheelScrollDirection.fromId(Config.parseIntOrDefault(properties.getProperty("WheelScrollDirection"), 0));
        this.scrollItemScaling = ScrollItemScaling.fromId(Config.parseIntOrDefault(properties.getProperty("ScrollItemScaling"), 0));
        debug = Config.parseIntOrDefault(properties.getProperty("Debug"), 0) != 0;
    }

    private static int parseIntOrDefault(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void save() {
        try {
            File config = new File(this.fileName);
            boolean existed = config.exists();
            File parentDir = config.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileWriter configWriter = new FileWriter(config);
            Config.writeBoolean(configWriter, "RMBTweak", this.rmbTweak);
            Config.writeBoolean(configWriter, "LMBTweakWithItem", this.lmbTweakWithItem);
            Config.writeBoolean(configWriter, "LMBTweakWithoutItem", this.lmbTweakWithoutItem);
            Config.writeBoolean(configWriter, "WheelTweak", this.wheelTweak);
            Config.writeString(configWriter, "WheelSearchOrder", String.valueOf(this.wheelSearchOrder.ordinal()));
            Config.writeString(configWriter, "WheelScrollDirection", String.valueOf(this.wheelScrollDirection.ordinal()));
            Config.writeString(configWriter, "ScrollItemScaling", String.valueOf(this.scrollItemScaling.ordinal()));
            Config.writeBoolean(configWriter, "Debug", debug);
            configWriter.close();
            if (!existed) {
                Logger.Log("Created the config file.");
            }
        }
        catch (IOException e) {
            Logger.Log("Failed to write the config file: " + this.fileName);
            e.printStackTrace();
        }
    }

    private static void writeString(FileWriter configWriter, String name, String value) throws IOException {
        configWriter.write(name + "=" + value + "\n");
    }

    private static void writeBoolean(FileWriter configWriter, String name, boolean value) throws IOException {
        Config.writeString(configWriter, name, value ? "1" : "0");
    }

    static {
        defaultValues.setProperty("RMBTweak", "1");
        defaultValues.setProperty("LMBTweakWithItem", "1");
        defaultValues.setProperty("LMBTweakWithoutItem", "1");
        defaultValues.setProperty("WheelTweak", "1");
        defaultValues.setProperty("WheelSearchOrder", "1");
        defaultValues.setProperty("WheelScrollDirection", "0");
        defaultValues.setProperty("ScrollItemScaling", "0");
        defaultValues.setProperty("Debug", "0");
    }
}

