/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry.register;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public record RegisterParticleProviders(String owner, BiConsumer<SimpleParticleType, SimpleParticleProviderBuilder> registerSimple) {
    public void add(Supplier<SimpleParticleType> type, SimpleParticleProviderBuilder provider) {
        this.add(type.get(), provider);
    }

    public void add(String id, SimpleParticleProviderBuilder provider) {
        this.add(ResourceLocation.tryBuild((String)this.owner, (String)id), provider);
    }

    public void add(ResourceLocation id, SimpleParticleProviderBuilder provider) {
        ParticleType type;
        if (BuiltInRegistries.PARTICLE_TYPE.containsKey(id)) {
            type = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(id);
            if (!(type instanceof SimpleParticleType)) {
                throw new IllegalStateException("Particle type '" + String.valueOf(id) + "' is not a SimpleParticleType! type=" + String.valueOf(type));
            }
        } else {
            throw new IllegalStateException("Particle type '" + String.valueOf(id) + "' has not been registered.");
        }
        SimpleParticleType simpleType = (SimpleParticleType)type;
        this.add(simpleType, provider);
    }

    public void add(SimpleParticleType type, SimpleParticleProviderBuilder provider) {
        this.registerSimple.accept(type, provider);
    }

    public static interface SimpleParticleProviderBuilder {
        public <T extends SpriteSet> ParticleProvider<SimpleParticleType> build(T var1);
    }
}

