/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.JadeIds;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    public static final ResourceLocation HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
    public static final ResourceLocation HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/full_blinking");
    public static final ResourceLocation HALF_HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/half");
    public static final ResourceLocation HALF_HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/half_blinking");
    public static final ResourceLocation EMPTY_HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/container");
    public static final ResourceLocation EMPTY_HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/container_blinking");
    private final float health;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private HealthTrackInfo track;

    public HealthElement(float maxHealth, float health) {
        this.health = health;
        if (maxHealth > (float)PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            if (!PluginConfig.INSTANCE.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = Mth.ceil((float)maxHealth);
                health = Mth.ceil((float)health);
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = PluginConfig.INSTANCE.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = Mth.ceil((float)(maxHealth *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = Mth.ceil((float)(maxHealth / (float)maxHeartsPerLine));
        }
    }

    @Override
    public Vec2 getSize() {
        if (this.showText()) {
            return new Vec2((float)(DisplayHelper.font().width(this.text) + 10), 9.0f);
        }
        return new Vec2((float)(8 * this.iconsPerLine + 1), (float)(5 + 4 * this.lineCount));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health));
        }
        if (this.track != null) {
            this.track.setHealth(this.health);
            this.track.update(Minecraft.getInstance().getTimer().getRealtimeDeltaTicks());
            lastHealth = this.track.getLastHealth() * 0.5f;
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = (int)(x + (float)xOffset);
            int yPos = (int)(y + (float)yOffset);
            helper.blitSprite(guiGraphics, blink ? EMPTY_HEART_BLINKING : EMPTY_HEART, xPos, yPos, 9, 9);
            if (i <= Mth.floor((float)health)) {
                helper.blitSprite(guiGraphics, HEART, xPos, yPos, 9, 9);
            }
            if ((float)i > health) {
                if (i <= Mth.floor((float)lastHealth)) {
                    helper.blitSprite(guiGraphics, HEART_BLINKING, xPos, yPos, 9, 9);
                } else if ((float)i > lastHealth && (float)i < lastHealth + 1.0f) {
                    helper.blitSprite(guiGraphics, HALF_HEART_BLINKING, xPos, yPos, 9, 9);
                }
                if ((float)i < health + 1.0f) {
                    helper.blitSprite(guiGraphics, HALF_HEART, xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(guiGraphics, this.text, x + 10.0f, y + 1.0f, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return I18n.get((String)"narration.jade.health", (Object[])new Object[]{Mth.ceil((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

